/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.gesture;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import androidx.viewpager.widget.ViewPager;

public class ViewPageGestureWrapper
implements GestureDetector.OnGestureListener {
    private GestureDetector mGestureDetector;
    private ViewPager mViewPager;

    public ViewPageGestureWrapper(Context context) {
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this);
    }

    public void onInterceptTouchEvent(MotionEvent event) {
    }

    public void setViewPager(ViewPager viewPager) {
        this.mViewPager = viewPager;
    }

    public void onTouchEvent(MotionEvent event) {
        this.mGestureDetector.onTouchEvent(event);
        switch (event.getAction()) {
            case 1: {
                if (this.mViewPager == null || !this.mViewPager.isFakeDragging()) break;
                this.mViewPager.endFakeDrag();
                break;
            }
            case 0: {
                if (this.mViewPager == null) break;
                this.mViewPager.beginFakeDrag();
            }
        }
    }

    public boolean onDown(MotionEvent e) {
        return false;
    }

    public void onShowPress(MotionEvent e) {
    }

    public boolean onSingleTapUp(MotionEvent e) {
        return false;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (this.mViewPager != null && this.mViewPager.isFakeDragging()) {
            this.mViewPager.fakeDragBy(-distanceX);
        }
        return false;
    }

    public void onLongPress(MotionEvent e) {
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        return false;
    }
}

