/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.render;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.Point;
import android.graphics.Rect;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.talpa.translate.base.utils.UtilsKt;
import com.talpa.translate.network.Result;
import com.talpa.translate.network.TransResponse;
import com.talpa.translate.ocr.datasource.CompleteResult;
import com.talpa.translate.ocr.result.Block;
import com.talpa.translate.ocr.result.OcrResult;
import com.talpa.translate.render.Render;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/talpa/translate/render/TranslatorRender;", "Lcom/talpa/translate/render/Render;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "mPath", "Landroid/graphics/Path;", "mPathMeasure", "Landroid/graphics/PathMeasure;", "mTextPaint", "Landroid/text/TextPaint;", "renderOverlay", "", "renderSource", "Landroid/graphics/Bitmap;", "completeResult", "Lcom/talpa/translate/ocr/datasource/CompleteResult;", "translation_foreignRelease"})
public final class TranslatorRender
implements Render {
    @NotNull
    private final Context context;
    @NotNull
    private TextPaint mTextPaint;
    @NotNull
    private final Path mPath;
    @NotNull
    private final PathMeasure mPathMeasure;

    public TranslatorRender(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.mTextPaint = new TextPaint(1);
        this.mPath = new Path();
        this.mPathMeasure = new PathMeasure();
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void renderOverlay(@Nullable Bitmap renderSource, @NotNull CompleteResult completeResult) {
        Intrinsics.checkNotNullParameter((Object)completeResult, (String)"completeResult");
        Bitmap bitmap2 = renderSource;
        if (bitmap2 == null) {
            return;
        }
        Canvas canvas = new Canvas(renderSource);
        OcrResult ocrResult = completeResult.getOcrResult();
        Intrinsics.checkNotNull((Object)ocrResult);
        Iterable $this$forEachIndexed$iv = ocrResult.getBlocks();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void block;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Block block2 = (Block)item$iv;
            int index = n;
            boolean bl2 = false;
            Rect rect = block.getRect();
            this.mTextPaint.setColor(-16777216);
            Point point = (Point)CollectionsKt.getOrNull(block.getBlockCorners(), (int)0);
            Integer n2 = point == null ? null : Integer.valueOf(point.x);
            int border01_x = n2 == null ? rect.left : n2;
            Point point2 = (Point)CollectionsKt.getOrNull(block.getBlockCorners(), (int)0);
            point = point2 == null ? null : Integer.valueOf(point2.y);
            int border01_y = point == null ? rect.top : point.intValue();
            Point point3 = (Point)CollectionsKt.getOrNull(block.getBlockCorners(), (int)1);
            point2 = point3 == null ? null : Integer.valueOf(point3.x);
            int border02_x = point2 == null ? rect.right : point2.intValue();
            Point point4 = (Point)CollectionsKt.getOrNull(block.getBlockCorners(), (int)1);
            point3 = point4 == null ? null : Integer.valueOf(point4.y);
            int border02_y = point3 == null ? rect.top : point3.intValue();
            Point point5 = (Point)CollectionsKt.getOrNull(block.getBlockCorners(), (int)2);
            point4 = point5 == null ? null : Integer.valueOf(point5.x);
            int border03_x = point4 == null ? rect.right : point4.intValue();
            Point point6 = (Point)CollectionsKt.getOrNull(block.getBlockCorners(), (int)2);
            point5 = point6 == null ? null : Integer.valueOf(point6.y);
            int border03_y = point5 == null ? rect.bottom : point5.intValue();
            Point point7 = (Point)CollectionsKt.getOrNull(block.getBlockCorners(), (int)3);
            point6 = point7 == null ? null : Integer.valueOf(point7.x);
            int border04_x = point6 == null ? rect.left : point6.intValue();
            Point point8 = (Point)CollectionsKt.getOrNull(block.getBlockCorners(), (int)3);
            point7 = point8 == null ? null : Integer.valueOf(point8.y);
            int border04_y = point7 == null ? rect.bottom : point7.intValue();
            double d = (border01_x - border02_x) * (border01_x - border02_x) + (border01_y - border02_y) * (border01_y - border02_y);
            boolean bl3 = false;
            double borderTopLen = Math.sqrt(d);
            double d2 = (border02_x - border03_x) * (border02_x - border03_x) + (border02_y - border03_y) * (border02_y - border03_y);
            boolean bl4 = false;
            double borderRightLen = Math.sqrt(d2);
            double d3 = (border03_x - border04_x) * (border03_x - border04_x) + (border03_y - border04_y) * (border03_y - border04_y);
            boolean bl5 = false;
            double borderBottomLen = Math.sqrt(d3);
            double d4 = (border01_x - border04_x) * (border01_x - border04_x) + (border01_y - border04_y) * (border01_y - border04_y);
            boolean bl6 = false;
            double borderLeftLen = Math.sqrt(d4);
            double textRectWidth = (borderTopLen + borderBottomLen) / (double)2;
            double textRectHeight = (borderRightLen + borderLeftLen) / (double)2;
            TransResponse transResponse = completeResult.getTransResponse();
            Intrinsics.checkNotNull((Object)transResponse);
            Result result = transResponse.getResult();
            Intrinsics.checkNotNull((Object)result);
            List<String> list = result.getTexts();
            Intrinsics.checkNotNull(list);
            int textSize = UtilsKt.getAutofitTextSize(list.get(index), this.mTextPaint, new Rect(0, 0, (int)textRectWidth, (int)textRectHeight), 16, this.getContext());
            this.mTextPaint.setTextSize(TypedValue.applyDimension((int)2, (float)textSize, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics()));
            TransResponse transResponse2 = completeResult.getTransResponse();
            Intrinsics.checkNotNull((Object)transResponse2);
            Result result2 = transResponse2.getResult();
            Intrinsics.checkNotNull((Object)result2);
            List<String> list2 = result2.getTexts();
            Intrinsics.checkNotNull(list2);
            String translation = list2.get(index);
            StaticLayout staticLayout = new StaticLayout((CharSequence)translation, this.mTextPaint, rect.width(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
            int n3 = staticLayout.getLineCount();
            boolean bl7 = false;
            int n4 = 0;
            n4 = 0;
            int n5 = n3;
            while (n4 < n5) {
                int it = n4++;
                boolean bl8 = false;
                this.mPath.reset();
                this.mPath.moveTo((float)border01_x, (float)border01_y);
                this.mPath.lineTo((float)border04_x, (float)border04_y);
                this.mPathMeasure.setPath(this.mPath, false);
                double left_each_len = borderLeftLen / (double)staticLayout.getLineCount();
                Path childPath = new Path();
                float f = (float)((double)it * left_each_len) + (float)left_each_len;
                float f2 = this.mPathMeasure.getLength();
                boolean bl9 = false;
                this.mPathMeasure.getSegment((float)((double)it * left_each_len), Math.min(f, f2), childPath, true);
                this.mPathMeasure.setPath(childPath, false);
                float[] posLeft = new float[2];
                this.mPathMeasure.getPosTan(this.mPathMeasure.getLength() / (float)2, posLeft, null);
                this.mPath.reset();
                this.mPath.moveTo((float)border02_x, (float)border02_y);
                this.mPath.lineTo((float)border03_x, (float)border03_y);
                this.mPathMeasure.setPath(this.mPath, false);
                double right_each_len = borderLeftLen / (double)staticLayout.getLineCount();
                childPath.reset();
                float f3 = (float)((double)it * right_each_len) + (float)right_each_len;
                float f4 = this.mPathMeasure.getLength();
                boolean bl10 = false;
                this.mPathMeasure.getSegment((float)((double)it * right_each_len), Math.min(f3, f4), childPath, true);
                this.mPathMeasure.setPath(childPath, false);
                float[] posRight = new float[2];
                this.mPathMeasure.getPosTan(this.mPathMeasure.getLength() / (float)2, posRight, null);
                Path centerLinePath = new Path();
                centerLinePath.moveTo(posLeft[0], posLeft[1]);
                centerLinePath.lineTo(posRight[0], posRight[1]);
                String string2 = translation;
                int n6 = staticLayout.getLineStart(it);
                int n7 = staticLayout.getLineEnd(it);
                boolean bl11 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n6, n7);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                StringBuilder drawingTextSb = new StringBuilder(string4);
                Paint.FontMetrics fm = this.mTextPaint.getFontMetrics();
                canvas.drawTextOnPath(drawingTextSb.toString(), centerLinePath, 0.0f, (fm.bottom - fm.top) / (float)2 - fm.bottom, (Paint)this.mTextPaint);
            }
        }
    }
}

