/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.base.utils;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.graphics.Rect;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.core.content.ContextCompat;
import androidx.core.os.LocaleListCompat;
import com.google.common.io.BaseEncoding;
import com.talpa.translate.activity.CameraActivityKt;
import com.talpa.translate.base.utils.LanguageUtilsKt;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004\u001a.\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e\u001a\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u001f\u0010\u001a\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u001d\"\u00020\u0004\u00a2\u0006\u0002\u0010\u001e\u001a\u0018\u0010\u001f\u001a\u0004\u0018\u00010\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0004\u001a\u0006\u0010#\u001a\u00020\f\u001a \u0010$\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0004\u001a\u0012\u0010(\u001a\u0004\u0018\u00010\u00042\u0006\u0010)\u001a\u00020*H\u0002\u001a\u001a\u0010+\u001a\u00020%*\u00020\u000e2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0012\u001a\u00020-\u001a\n\u0010.\u001a\u00020\f*\u00020\u000e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"MAX_TEXT_SIZE", "", "MIN_TEXT_SIZE", "PREFER_KEY_SOURCE_LANG", "", "PREFER_KEY_SOURCE_LANG_LABEL", "PREFER_KEY_TARGET_LANG", "PREFER_KEY_TARGET_LANG_LABEL", "PREFER_NAME", "SPACINGMULT", "", "checkPermission", "", "context", "Landroid/content/Context;", "crypt", "str", "getAutofitTextSize", "text", "paint", "Landroid/text/TextPaint;", "rect", "Landroid/graphics/Rect;", "maxTextSize", "getFreeSpace", "", "getLocaleListCompat", "Landroidx/core/os/LocaleListCompat;", "languages", "", "([Ljava/lang/String;)Landroidx/core/os/LocaleListCompat;", "getSignature", "pm", "Landroid/content/pm/PackageManager;", "packageName", "isSDCardEnable", "saveLanguage", "", "preferKey", "value", "signatureDigest", "sig", "Landroid/content/pm/Signature;", "clipboard", "label", "", "isNetworkConnected", "translation_foreignRelease"})
public final class UtilsKt {
    @NotNull
    public static final String PREFER_KEY_SOURCE_LANG = "key_source_lang";
    @NotNull
    public static final String PREFER_KEY_TARGET_LANG = "key_target_lang";
    @NotNull
    public static final String PREFER_KEY_SOURCE_LANG_LABEL = "key_source_lang_label";
    @NotNull
    public static final String PREFER_KEY_TARGET_LANG_LABEL = "key_target_lang_label";
    @NotNull
    public static final String PREFER_NAME = "prefer_camera";
    public static final int MAX_TEXT_SIZE = 16;
    public static final int MIN_TEXT_SIZE = 5;
    public static final float SPACINGMULT = 1.0f;

    public static final boolean checkPermission(@NotNull Context context) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            String[] $this$all$iv = CameraActivityKt.getPERMISSIONS_REQUIRED();
            boolean $i$f$all = false;
            String[] stringArray = $this$all$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (ContextCompat.checkSelfPermission((Context)context, (String)it) == 0) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    public static final void saveLanguage(@NotNull Context context, @NotNull String preferKey, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)preferKey, (String)"preferKey");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences prefer = context.getSharedPreferences(PREFER_NAME, 0);
        prefer.edit().putString(preferKey, value).apply();
    }

    public static /* synthetic */ void saveLanguage$default(Context context, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = PREFER_KEY_SOURCE_LANG;
        }
        UtilsKt.saveLanguage(context, string2, string3);
    }

    public static final boolean isNetworkConnected(@NotNull Context $this$isNetworkConnected) {
        NetworkInfo networkInfo;
        Intrinsics.checkNotNullParameter((Object)$this$isNetworkConnected, (String)"<this>");
        Object object = $this$isNetworkConnected.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)object;
        if (Build.VERSION.SDK_INT >= 23) {
            Network network = connectivityManager.getActiveNetwork();
            if (network == null) {
                return false;
            }
            Network network2 = network;
            Network nw = network2;
            NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(nw);
            if (networkCapabilities == null) {
                return false;
            }
            Network actNw = network = networkCapabilities;
            return actNw.hasTransport(1) ? true : (actNw.hasTransport(0) ? true : (actNw.hasTransport(3) ? true : actNw.hasTransport(2)));
        }
        NetworkInfo networkInfo2 = connectivityManager.getActiveNetworkInfo();
        if (networkInfo2 == null) {
            return false;
        }
        NetworkInfo nwInfo = networkInfo = networkInfo2;
        return nwInfo.isConnected();
    }

    @NotNull
    public static final String crypt(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        CharSequence charSequence = str;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return "";
        }
        StringBuffer hexString = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            String string2 = str;
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            md.update(byArray);
            byte[] hash = md.digest();
            int n = hash.length;
            bl2 = false;
            int n2 = 0;
            int n3 = n;
            for (n2 = 0; n2 < n3; ++n2) {
                int it = n2;
                boolean bl3 = false;
                if ((0xFF & hash[it]) < 16) {
                    hexString.append(Intrinsics.stringPlus((String)"0", (Object)Integer.toHexString(0xFF & hash[it])));
                    continue;
                }
                hexString.append(Integer.toHexString(0xFF & hash[it]));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        String string3 = hexString.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"hexString.toString()");
        return string3;
    }

    public static final boolean isSDCardEnable() {
        return Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState());
    }

    public static final long getFreeSpace() {
        if (!UtilsKt.isSDCardEnable()) {
            return -1L;
        }
        StatFs stat = new StatFs(Environment.getExternalStorageDirectory().getPath());
        long blockSize = stat.getBlockSizeLong();
        long availableBlocks = stat.getAvailableBlocksLong();
        long size = availableBlocks * blockSize / 1024L;
        return size;
    }

    @NotNull
    public static final LocaleListCompat getLocaleListCompat(String ... languages) {
        Intrinsics.checkNotNullParameter((Object)languages, (String)"languages");
        CharSequence charSequence = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder builder2 = charSequence;
        boolean bl3 = false;
        String[] $this$forEach$iv = languages;
        boolean $i$f$forEach = false;
        String[] stringArray = $this$forEach$iv;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = stringArray[i];
            boolean bl4 = false;
            builder2.append(it);
            builder2.append(",");
        }
        String string2 = charSequence.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder()\n        .also { builder ->\n            languages.forEach {\n                builder.append(it)\n                builder.append(\",\")\n            }\n        }.toString()");
        String supportList = string2;
        charSequence = Locale.getDefault().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getDefault().language");
        string2 = LocaleListCompat.forLanguageTags((String)LanguageUtilsKt.getOrderedLanguageList((String)charSequence, supportList));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"forLanguageTags(getOrderedLanguageList(Locale.getDefault().language, supportList))");
        return string2;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final String getSignature(@NotNull PackageManager pm, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)pm, (String)"pm");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        try {
            packageInfo = pm.getPackageInfo(packageName, 64);
            var3_3 = packageInfo;
            if ((var3_3 == null ? null : var3_3.signatures) == null) ** GOTO lbl-1000
            var3_3 = packageInfo.signatures;
            Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"packageInfo.signatures");
            var3_3 = (Object[])var3_3;
            var4_5 = false;
            if (((Signature[])var3_3).length == 0 || packageInfo.signatures[0] == null) lbl-1000:
            // 2 sources

            {
                v0 = null;
            } else {
                var3_3 = packageInfo.signatures[0];
                Intrinsics.checkNotNullExpressionValue((Object)var3_3, (String)"packageInfo.signatures[0]");
                v0 = UtilsKt.signatureDigest(var3_3);
            }
            var2_2 = v0;
        }
        catch (PackageManager.NameNotFoundException e) {
            var2_2 = null;
        }
        return var2_2;
    }

    private static final String signatureDigest(Signature sig) {
        String string2;
        byte[] signature = sig.toByteArray();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] digest = md.digest(signature);
            string2 = BaseEncoding.base16().lowerCase().encode(digest);
        }
        catch (NoSuchAlgorithmException e) {
            string2 = null;
        }
        return string2;
    }

    public static final int getAutofitTextSize(@NotNull String text, @NotNull TextPaint paint, @NotNull Rect rect, int maxTextSize, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int textsize = maxTextSize;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        paint.setTextSize(TypedValue.applyDimension((int)2, (float)textsize, (DisplayMetrics)displayMetrics));
        StaticLayout staticLayout = new StaticLayout((CharSequence)text, paint, rect.width(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        while (staticLayout.getHeight() > rect.height() && textsize > 5) {
            int n = textsize;
            textsize = n + -1;
            paint.setTextSize(TypedValue.applyDimension((int)2, (float)textsize, (DisplayMetrics)displayMetrics));
            staticLayout = new StaticLayout((CharSequence)text, paint, rect.width(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        }
        return textsize;
    }

    public static final void clipboard(@NotNull Context $this$clipboard, @NotNull CharSequence label, @NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)$this$clipboard, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            String newLabel = $this$clipboard.getPackageName() + '_' + label;
            Object object = $this$clipboard.getSystemService("clipboard");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.content.ClipboardManager");
            }
            ClipboardManager cm = (ClipboardManager)object;
            ClipData clipData = ClipData.newPlainText((CharSequence)newLabel, (CharSequence)text);
            cm.setPrimaryClip(clipData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

