/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.video.encoding;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Bundle;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.talpa.translate.camera.view.CameraLogger;
import com.talpa.translate.camera.view.video.encoding.EncoderThread;
import com.talpa.translate.camera.view.video.encoding.MediaEncoder;
import com.talpa.translate.camera.view.video.encoding.MediaEncoderEngine;
import com.talpa.translate.camera.view.video.encoding.OutputBuffer;
import com.talpa.translate.camera.view.video.encoding.OutputBufferPool;
import com.talpa.translate.camera.view.video.encoding.VideoConfig;
import java.io.IOException;

@RequiresApi(api=18)
abstract class VideoMediaEncoder<C extends VideoConfig>
extends MediaEncoder {
    private static final String TAG = VideoMediaEncoder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    protected C mConfig;
    protected Surface mSurface;
    protected int mFrameNumber = -1;
    private boolean mSyncFrameFound = false;

    VideoMediaEncoder(@NonNull C config) {
        super("VideoEncoder");
        this.mConfig = config;
    }

    @Override
    @EncoderThread
    protected void onPrepare(@NonNull MediaEncoderEngine.Controller controller, long maxLengthUs) {
        MediaFormat format = MediaFormat.createVideoFormat((String)((VideoConfig)this.mConfig).mimeType, (int)((VideoConfig)this.mConfig).width, (int)((VideoConfig)this.mConfig).height);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", ((VideoConfig)this.mConfig).bitRate);
        format.setInteger("frame-rate", ((VideoConfig)this.mConfig).frameRate);
        format.setInteger("i-frame-interval", 1);
        format.setInteger("rotation-degrees", ((VideoConfig)this.mConfig).rotation);
        try {
            this.mMediaCodec = ((VideoConfig)this.mConfig).encoder != null ? MediaCodec.createByCodecName((String)((VideoConfig)this.mConfig).encoder) : MediaCodec.createEncoderByType((String)((VideoConfig)this.mConfig).mimeType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mMediaCodec.configure(format, null, null, 1);
        this.mSurface = this.mMediaCodec.createInputSurface();
        this.mMediaCodec.start();
    }

    @Override
    @EncoderThread
    protected void onStart() {
        this.mFrameNumber = 0;
    }

    @Override
    @EncoderThread
    protected void onStop() {
        LOG.i("onStop", "setting mFrameNumber to 1 and signaling the end of input stream.");
        this.mFrameNumber = -1;
        this.mMediaCodec.signalEndOfInputStream();
        this.drainOutput(true);
    }

    @Override
    protected void onWriteOutput(@NonNull OutputBufferPool pool, @NonNull OutputBuffer buffer) {
        if (!this.mSyncFrameFound) {
            boolean hasFlag;
            LOG.w("onWriteOutput:", "sync frame not found yet. Checking.");
            int flag = 1;
            boolean bl = hasFlag = (buffer.info.flags & flag) == flag;
            if (hasFlag) {
                LOG.w("onWriteOutput:", "SYNC FRAME FOUND!");
                this.mSyncFrameFound = true;
                super.onWriteOutput(pool, buffer);
            } else {
                LOG.w("onWriteOutput:", "DROPPING FRAME and requesting a sync frame soon.");
                if (Build.VERSION.SDK_INT >= 19) {
                    Bundle params = new Bundle();
                    params.putInt("request-sync", 0);
                    this.mMediaCodec.setParameters(params);
                }
                pool.recycle(buffer);
            }
        } else {
            super.onWriteOutput(pool, buffer);
        }
    }

    @Override
    protected int getEncodedBitRate() {
        return ((VideoConfig)this.mConfig).bitRate;
    }

    protected boolean shouldRenderFrame(long timestampUs) {
        if (timestampUs == 0L) {
            return false;
        }
        if (this.mFrameNumber < 0) {
            return false;
        }
        if (this.hasReachedMaxLength()) {
            return false;
        }
        ++this.mFrameNumber;
        return true;
    }
}

