/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.ocr;

import android.content.Context;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.mlkit.vision.text.TextRecognition;
import com.google.mlkit.vision.text.TextRecognizer;
import com.google.mlkit.vision.text.TextRecognizerOptionsInterface;
import com.google.mlkit.vision.text.chinese.ChineseTextRecognizerOptions;
import com.google.mlkit.vision.text.devanagari.DevanagariTextRecognizerOptions;
import com.google.mlkit.vision.text.japanese.JapaneseTextRecognizerOptions;
import com.google.mlkit.vision.text.korean.KoreanTextRecognizerOptions;
import com.google.mlkit.vision.text.latin.TextRecognizerOptions;
import com.talpa.translate.base.utils.ConstantKt;
import com.talpa.translate.factory.TranslatorFactory;
import com.talpa.translate.ocr.Recognizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/talpa/translate/ocr/OcrDispatcher;", "", "()V", "googleOcrEnable", "", "dispatchOcrClient", "Lcom/google/mlkit/vision/text/TextRecognizer;", "sourceLanguage", "", "dispatchOcrClient$translation_foreignRelease", "dispatchOcrTranslator", "Lcom/talpa/translate/ocr/Recognizer;", "context", "Landroid/content/Context;", "getGoogleOcrEnable", "setGoogleOcrEnable", "", "translation_foreignRelease"})
@StabilityInferred(parameters=0)
public final class OcrDispatcher {
    @NotNull
    public static final OcrDispatcher INSTANCE = new OcrDispatcher();
    private static boolean googleOcrEnable = true;
    public static final int $stable = 8;

    private OcrDispatcher() {
    }

    public final void setGoogleOcrEnable(boolean googleOcrEnable) {
        OcrDispatcher.googleOcrEnable = googleOcrEnable;
    }

    public final boolean getGoogleOcrEnable() {
        return googleOcrEnable;
    }

    @NotNull
    public final Recognizer dispatchOcrTranslator(@NotNull Context context, @NotNull String sourceLanguage) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sourceLanguage, (String)"sourceLanguage");
        return StringsKt.contains$default((CharSequence)ConstantKt.getNonFreeOcrLanguages(), (CharSequence)sourceLanguage, (boolean)false, (int)2, null) && googleOcrEnable ? TranslatorFactory.Companion.getGoogleRecognizer(context) : TranslatorFactory.Companion.getFirebaseRecognizer(context);
    }

    @NotNull
    public final TextRecognizer dispatchOcrClient$translation_foreignRelease(@NotNull String sourceLanguage) {
        TextRecognizer textRecognizer;
        Intrinsics.checkNotNullParameter((Object)sourceLanguage, (String)"sourceLanguage");
        if (StringsKt.equals((String)sourceLanguage, (String)ConstantKt.getChineseTag(), (boolean)true)) {
            TextRecognizer textRecognizer2 = TextRecognition.getClient((TextRecognizerOptionsInterface)((TextRecognizerOptionsInterface)new ChineseTextRecognizerOptions.Builder().build()));
            Intrinsics.checkNotNullExpressionValue((Object)textRecognizer2, (String)"{\n                TextRecognition.getClient(ChineseTextRecognizerOptions.Builder().build())\n            }");
            textRecognizer = textRecognizer2;
        } else if (StringsKt.equals((String)sourceLanguage, (String)ConstantKt.getJapaneseTag(), (boolean)true)) {
            TextRecognizer textRecognizer3 = TextRecognition.getClient((TextRecognizerOptionsInterface)((TextRecognizerOptionsInterface)new JapaneseTextRecognizerOptions.Builder().build()));
            Intrinsics.checkNotNullExpressionValue((Object)textRecognizer3, (String)"{\n                TextRecognition.getClient(JapaneseTextRecognizerOptions.Builder().build())\n            }");
            textRecognizer = textRecognizer3;
        } else if (StringsKt.equals((String)sourceLanguage, (String)ConstantKt.getKoreanTag(), (boolean)true)) {
            TextRecognizer textRecognizer4 = TextRecognition.getClient((TextRecognizerOptionsInterface)((TextRecognizerOptionsInterface)new KoreanTextRecognizerOptions.Builder().build()));
            Intrinsics.checkNotNullExpressionValue((Object)textRecognizer4, (String)"{\n                TextRecognition.getClient(KoreanTextRecognizerOptions.Builder().build())\n            }");
            textRecognizer = textRecognizer4;
        } else if (ConstantKt.getDevanagariTags().contains(sourceLanguage)) {
            TextRecognizer textRecognizer5 = TextRecognition.getClient((TextRecognizerOptionsInterface)((TextRecognizerOptionsInterface)new DevanagariTextRecognizerOptions.Builder().build()));
            Intrinsics.checkNotNullExpressionValue((Object)textRecognizer5, (String)"{\n                TextRecognition.getClient(DevanagariTextRecognizerOptions.Builder().build())\n            }");
            textRecognizer = textRecognizer5;
        } else {
            TextRecognizer textRecognizer6 = TextRecognition.getClient((TextRecognizerOptionsInterface)((TextRecognizerOptionsInterface)TextRecognizerOptions.DEFAULT_OPTIONS));
            Intrinsics.checkNotNullExpressionValue((Object)textRecognizer6, (String)"{\n                TextRecognition.getClient(TextRecognizerOptions.DEFAULT_OPTIONS)\n            }");
            textRecognizer = textRecognizer6;
        }
        return textRecognizer;
    }
}

