/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.surface.opengl.surface;

import android.graphics.Bitmap;
import android.opengl.EGL14;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import com.talpa.translate.camera.surface.opengl.core.EglCore;
import com.talpa.translate.camera.surface.opengl.core.Egloo;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 *2\u00020\u0001:\u0001*B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0010J\u0006\u0010\u0013\u001a\u00020\u0010J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u0019\u001a\u00020\u0017J\b\u0010\u001a\u001a\u00020\u0017H\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0010H\u0004J\u0010\u0010 \u001a\u00020!2\b\b\u0002\u0010\"\u001a\u00020#J\u0018\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\b\b\u0002\u0010\"\u001a\u00020#J\u0018\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\b\b\u0002\u0010\"\u001a\u00020#R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/talpa/translate/camera/surface/opengl/surface/EglSurface;", "", "eglCore", "Lcom/talpa/translate/camera/surface/opengl/core/EglCore;", "eglSurface", "Landroid/opengl/EGLSurface;", "(Lcom/talpa/translate/camera/surface/opengl/core/EglCore;Landroid/opengl/EGLSurface;)V", "getEglCore", "()Lcom/talpa/translate/camera/surface/opengl/core/EglCore;", "setEglCore", "(Lcom/talpa/translate/camera/surface/opengl/core/EglCore;)V", "getEglSurface", "()Landroid/opengl/EGLSurface;", "setEglSurface", "(Landroid/opengl/EGLSurface;)V", "height", "", "width", "getHeight", "getWidth", "isCurrent", "", "makeCurrent", "", "readSurface", "makeNothingCurrent", "release", "setHeight", "setPresentationTime", "nsecs", "", "setWidth", "toByteArray", "", "format", "Landroid/graphics/Bitmap$CompressFormat;", "toFile", "file", "Ljava/io/File;", "toOutputStream", "stream", "Ljava/io/OutputStream;", "Companion", "translation_foreignRelease"})
public abstract class EglSurface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private EglCore eglCore;
    @NotNull
    private EGLSurface eglSurface;
    private int width;
    private int height;
    private static final String TAG = EglSurface.class.getSimpleName();

    protected EglSurface(@NotNull EglCore eglCore, @NotNull EGLSurface eglSurface) {
        Intrinsics.checkNotNullParameter((Object)eglCore, (String)"eglCore");
        Intrinsics.checkNotNullParameter((Object)eglSurface, (String)"eglSurface");
        this.eglCore = eglCore;
        this.eglSurface = eglSurface;
        this.width = -1;
        this.height = -1;
    }

    @NotNull
    protected final EglCore getEglCore() {
        return this.eglCore;
    }

    protected final void setEglCore(@NotNull EglCore eglCore) {
        Intrinsics.checkNotNullParameter((Object)eglCore, (String)"<set-?>");
        this.eglCore = eglCore;
    }

    @NotNull
    protected final EGLSurface getEglSurface() {
        return this.eglSurface;
    }

    protected final void setEglSurface(@NotNull EGLSurface eGLSurface) {
        Intrinsics.checkNotNullParameter((Object)eGLSurface, (String)"<set-?>");
        this.eglSurface = eGLSurface;
    }

    protected final void setWidth(int width) {
        this.width = width;
    }

    protected final void setHeight(int height) {
        this.height = height;
    }

    public final int getWidth() {
        return this.width < 0 ? this.eglCore.querySurface$translation_foreignRelease(this.eglSurface, 12375) : this.width;
    }

    public final int getHeight() {
        return this.height < 0 ? this.eglCore.querySurface$translation_foreignRelease(this.eglSurface, 12374) : this.height;
    }

    public void release() {
        this.eglCore.releaseSurface$translation_foreignRelease(this.eglSurface);
        EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
        Intrinsics.checkNotNullExpressionValue((Object)eGLSurface, (String)"EGL_NO_SURFACE");
        this.eglSurface = eGLSurface;
        this.height = -1;
        this.width = -1;
    }

    public final boolean isCurrent() {
        return this.eglCore.isSurfaceCurrent$translation_foreignRelease(this.eglSurface);
    }

    public final void makeCurrent() {
        this.eglCore.makeSurfaceCurrent$translation_foreignRelease(this.eglSurface);
    }

    public final void makeCurrent(@NotNull EglSurface readSurface) {
        Intrinsics.checkNotNullParameter((Object)readSurface, (String)"readSurface");
        this.eglCore.makeSurfaceCurrent$translation_foreignRelease(this.eglSurface, readSurface.eglSurface);
    }

    public final void makeNothingCurrent() {
        this.eglCore.makeCurrent();
    }

    public final void setPresentationTime(long nsecs) {
        this.eglCore.setSurfacePresentationTime$translation_foreignRelease(this.eglSurface, nsecs);
    }

    public final void toOutputStream(@NotNull OutputStream stream, @NotNull Bitmap.CompressFormat format) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        if (!this.isCurrent()) {
            throw new RuntimeException("Expected EGL context/surface is not current");
        }
        int width = this.getWidth();
        int height = this.getHeight();
        ByteBuffer buf = ByteBuffer.allocateDirect(width * height * 4);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)buf);
        Egloo.checkGlError("glReadPixels");
        buf.rewind();
        Bitmap bitmap2 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap2.copyPixelsFromBuffer((Buffer)buf);
        bitmap2.compress(format, 90, stream);
        bitmap2.recycle();
    }

    public static /* synthetic */ void toOutputStream$default(EglSurface eglSurface, OutputStream outputStream, Bitmap.CompressFormat compressFormat, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toOutputStream");
        }
        if ((n & 2) != 0) {
            compressFormat = Bitmap.CompressFormat.PNG;
        }
        eglSurface.toOutputStream(outputStream, compressFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void toFile(@NotNull File file, @NotNull Bitmap.CompressFormat format) throws IOException {
        FilterOutputStream filterOutputStream;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        FilterOutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(file.toString()));
            this.toOutputStream(stream, format);
            filterOutputStream = stream;
        }
        catch (Throwable throwable) {
            FilterOutputStream filterOutputStream2 = stream;
            if (filterOutputStream2 != null) {
                filterOutputStream2.close();
            }
            throw throwable;
        }
        filterOutputStream.close();
    }

    public static /* synthetic */ void toFile$default(EglSurface eglSurface, File file, Bitmap.CompressFormat compressFormat, int n, Object object) throws IOException {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toFile");
        }
        if ((n & 2) != 0) {
            compressFormat = Bitmap.CompressFormat.PNG;
        }
        eglSurface.toFile(file, compressFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] toByteArray(@NotNull Bitmap.CompressFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Closeable closeable = stream;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ByteArrayOutputStream it = (ByteArrayOutputStream)closeable;
            boolean bl3 = false;
            this.toOutputStream(it, format);
            byte[] byArray = it.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"it.toByteArray()");
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ byte[] toByteArray$default(EglSurface eglSurface, Bitmap.CompressFormat compressFormat, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toByteArray");
        }
        if ((n & 1) != 0) {
            compressFormat = Bitmap.CompressFormat.PNG;
        }
        return eglSurface.toByteArray(compressFormat);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0084\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/talpa/translate/camera/surface/opengl/surface/EglSurface$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "getTAG$annotations", "getTAG", "()Ljava/lang/String;", "translation_foreignRelease"})
    public static final class Companion {
        private Companion() {
        }

        protected final String getTAG() {
            return TAG;
        }

        protected static /* synthetic */ void getTAG$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

