/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view;

import android.graphics.BitmapFactory;
import android.location.Location;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.talpa.translate.camera.view.BitmapCallback;
import com.talpa.translate.camera.view.CameraUtils;
import com.talpa.translate.camera.view.FileCallback;
import com.talpa.translate.camera.view.controls.Facing;
import com.talpa.translate.camera.view.controls.PictureFormat;
import com.talpa.translate.camera.view.size.Size;
import java.io.File;

public class PictureResult {
    private final boolean isSnapshot;
    private final Location location;
    private final int rotation;
    private final Size size;
    private final Facing facing;
    private final byte[] data;
    private final PictureFormat format;

    PictureResult(@NonNull Stub builder2) {
        this.isSnapshot = builder2.isSnapshot;
        this.location = builder2.location;
        this.rotation = builder2.rotation;
        this.size = builder2.size;
        this.facing = builder2.facing;
        this.data = builder2.data;
        this.format = builder2.format;
    }

    public boolean isSnapshot() {
        return this.isSnapshot;
    }

    @Nullable
    public Location getLocation() {
        return this.location;
    }

    public int getRotation() {
        return this.rotation;
    }

    @NonNull
    public Size getSize() {
        return this.size;
    }

    @NonNull
    public Facing getFacing() {
        return this.facing;
    }

    @NonNull
    public byte[] getData() {
        return this.data;
    }

    @NonNull
    public PictureFormat getFormat() {
        return this.format;
    }

    public void toBitmap(int maxWidth, int maxHeight, @NonNull BitmapCallback callback) {
        if (this.format == PictureFormat.JPEG) {
            CameraUtils.decodeBitmap(this.getData(), maxWidth, maxHeight, new BitmapFactory.Options(), this.rotation, callback);
        } else if (this.format == PictureFormat.DNG && Build.VERSION.SDK_INT >= 24) {
            CameraUtils.decodeBitmap(this.getData(), maxWidth, maxHeight, new BitmapFactory.Options(), this.rotation, callback);
        } else {
            throw new UnsupportedOperationException("PictureResult.toBitmap() does not support this picture format: " + this.format);
        }
    }

    public void toBitmap(@NonNull BitmapCallback callback) {
        this.toBitmap(-1, -1, callback);
    }

    public void toFile(@NonNull File file, @NonNull FileCallback callback) {
        CameraUtils.writeToFile(this.getData(), file, callback);
    }

    public static class Stub {
        public boolean isSnapshot;
        public Location location;
        public int rotation;
        public Size size;
        public Facing facing;
        public byte[] data;
        public PictureFormat format;

        Stub() {
        }
    }
}

