/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.filters;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.talpa.translate.camera.surface.opengl.core.Egloo;
import com.talpa.translate.camera.view.filter.BaseFilter;
import com.talpa.translate.camera.view.filter.OneParameterFilter;

public class GammaFilter
extends BaseFilter
implements OneParameterFilter {
    private static final String FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nuniform float gamma;\nvoid main() {\n  vec4 textureColor = texture2D(sTexture, vTextureCoord);\n  gl_FragColor = vec4(pow(textureColor.rgb, vec3(gamma)), textureColor.w);\n}\n";
    private float gamma = 2.0f;
    private int gammaLocation = -1;

    public void setGamma(float gamma) {
        if (gamma < 0.0f) {
            gamma = 0.0f;
        }
        if (gamma > 2.0f) {
            gamma = 2.0f;
        }
        this.gamma = gamma;
    }

    public float getGamma() {
        return this.gamma;
    }

    @Override
    public void setParameter1(float value) {
        this.setGamma(value * 2.0f);
    }

    @Override
    public float getParameter1() {
        return this.getGamma() / 2.0f;
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return FRAGMENT_SHADER;
    }

    @Override
    public void onCreate(int programHandle) {
        super.onCreate(programHandle);
        this.gammaLocation = GLES20.glGetUniformLocation((int)programHandle, (String)"gamma");
        Egloo.checkGlProgramLocation(this.gammaLocation, "gamma");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.gammaLocation = -1;
    }

    @Override
    protected void onPreDraw(long timestampUs, @NonNull float[] transformMatrix) {
        super.onPreDraw(timestampUs, transformMatrix);
        GLES20.glUniform1f((int)this.gammaLocation, (float)this.gamma);
        Egloo.checkGlError("glUniform1f");
    }
}

