/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.ocr.text;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import com.talpa.translate.base.common.FrameMetadata;
import com.talpa.translate.base.utils.UtilsKt;
import com.talpa.translate.ocr.TextDrawer;
import com.talpa.translate.ocr.result.Block;
import com.talpa.translate.ocr.result.OcrResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/talpa/translate/ocr/text/CompatTextDrawer;", "Lcom/talpa/translate/ocr/TextDrawer;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "mBackgroundPaint", "Landroid/graphics/Paint;", "mTextPaint", "Landroid/text/TextPaint;", "draw", "Landroid/graphics/Bitmap;", "backgound", "frameMetadata", "Lcom/talpa/translate/base/common/FrameMetadata;", "ocrResult", "Lcom/talpa/translate/ocr/result/OcrResult;", "transResult", "", "", "translation_googleRelease"})
public final class CompatTextDrawer
implements TextDrawer {
    private TextPaint mTextPaint;
    private Paint mBackgroundPaint;
    @NotNull
    private final Context context;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Bitmap draw(@NotNull Bitmap backgound, @NotNull FrameMetadata frameMetadata, @NotNull OcrResult ocrResult, @NotNull List<String> transResult) {
        Intrinsics.checkNotNullParameter((Object)backgound, (String)"backgound");
        Intrinsics.checkNotNullParameter((Object)frameMetadata, (String)"frameMetadata");
        Intrinsics.checkNotNullParameter((Object)ocrResult, (String)"ocrResult");
        Intrinsics.checkNotNullParameter(transResult, (String)"transResult");
        Bitmap newBitmap = Bitmap.createBitmap((int)backgound.getWidth(), (int)backgound.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        newBitmap.setHasAlpha(true);
        Canvas canvas = new Canvas(newBitmap);
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        canvas.drawBitmap(newBitmap, 0.0f, 0.0f, null);
        TextPaint textPaint = new TextPaint(1);
        boolean bl = false;
        boolean bl2 = false;
        TextPaint it = textPaint;
        boolean bl3 = false;
        Resources resources = this.context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        it.density = resources.getDisplayMetrics().density;
        TextPaint textPaint2 = textPaint;
        textPaint2.setColor(-16777216);
        Iterable $this$forEachIndexed$iv = ocrResult.getBlocks();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void block;
            int n = index$iv++;
            boolean bl4 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Block block2 = (Block)item$iv;
            int index = n;
            boolean bl5 = false;
            Rect rect = block.getRect();
            String string2 = transResult.get(index);
            if (string2 == null) {
                string2 = "";
            }
            int textSize = UtilsKt.getAutofitTextSize(string2, this.mTextPaint, rect, 18, this.context);
            float f = textSize;
            Resources resources2 = this.context.getResources();
            Intrinsics.checkNotNullExpressionValue((Object)resources2, (String)"context.resources");
            this.mTextPaint.setTextSize(TypedValue.applyDimension((int)2, (float)f, (DisplayMetrics)resources2.getDisplayMetrics()));
            String string3 = transResult.get(index);
            if (string3 == null) {
                string3 = "";
            }
            StaticLayout staticLayout = new StaticLayout((CharSequence)string3, this.mTextPaint, rect.width(), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true);
            canvas.drawRect(rect, this.mBackgroundPaint);
            canvas.save();
            canvas.translate((float)rect.left, (float)rect.top);
            staticLayout.draw(canvas);
            canvas.restore();
        }
        Bitmap bitmap2 = newBitmap;
        Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"newBitmap");
        return bitmap2;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public CompatTextDrawer(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.mTextPaint = new TextPaint(1);
        this.mBackgroundPaint = new Paint();
        this.mTextPaint.setColor(-16777216);
        this.mBackgroundPaint.setColor(-1);
    }
}

