/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.ocr.thirdpart.leptonica;

import android.graphics.Rect;
import androidx.annotation.ColorInt;
import androidx.annotation.Size;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class Pix {
    public static final int INDEX_W = 0;
    public static final int INDEX_H = 1;
    public static final int INDEX_D = 2;
    private final long mNativePix;
    private boolean mRecycled;

    public Pix(long nativePix) {
        this.mNativePix = nativePix;
        this.mRecycled = false;
    }

    public Pix(int width, int height, int depth) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Pix width and height must be > 0");
        }
        if (depth != 1 && depth != 2 && depth != 4 && depth != 8 && depth != 16 && depth != 24 && depth != 32) {
            throw new IllegalArgumentException("Depth must be one of 1, 2, 4, 8, 16, or 32");
        }
        this.mNativePix = Pix.nativeCreatePix(width, height, depth);
        this.mRecycled = false;
    }

    public long getNativePix() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return this.mNativePix;
    }

    public byte[] getData() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        byte[] buffer = Pix.nativeGetData(this.mNativePix);
        if (buffer == null) {
            throw new RuntimeException("native getData failed");
        }
        return buffer;
    }

    public int[] getDimensions() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        int[] dimensions = new int[3];
        if (this.getDimensions(dimensions)) {
            return dimensions;
        }
        return null;
    }

    public boolean getDimensions(@Size(min=3L) int[] dimensions) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return Pix.nativeGetDimensions(this.mNativePix, dimensions);
    }

    public Pix clone() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        long nativePix = Pix.nativeClone(this.mNativePix);
        if (nativePix == 0L) {
            throw new OutOfMemoryError();
        }
        return new Pix(nativePix);
    }

    public Pix copy() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        long nativePix = Pix.nativeCopy(this.mNativePix);
        if (nativePix == 0L) {
            throw new OutOfMemoryError();
        }
        return new Pix(nativePix);
    }

    public boolean invert() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return Pix.nativeInvert(this.mNativePix);
    }

    public void recycle() {
        if (!this.mRecycled) {
            Pix.nativeDestroy(this.mNativePix);
            this.mRecycled = true;
        }
    }

    public static Pix createFromPix(byte[] pixData, int width, int height, int depth) {
        long nativePix = Pix.nativeCreateFromData(pixData, width, height, depth);
        if (nativePix == 0L) {
            throw new OutOfMemoryError();
        }
        return new Pix(nativePix);
    }

    public Rect getRect() {
        int w = this.getWidth();
        int h = this.getHeight();
        return new Rect(0, 0, w, h);
    }

    public int getWidth() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return Pix.nativeGetWidth(this.mNativePix);
    }

    public int getHeight() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return Pix.nativeGetHeight(this.mNativePix);
    }

    public int getDepth() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return Pix.nativeGetDepth(this.mNativePix);
    }

    public int getSpp() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return Pix.nativeGetSpp(this.mNativePix);
    }

    public int getImageFormat() {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        return Pix.nativeGetInputFormat(this.mNativePix);
    }

    public int getRefCount() {
        return Pix.nativeGetRefCount(this.mNativePix);
    }

    public int getPixel(int x, int y) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        if (x < 0 || x >= this.getWidth()) {
            throw new IllegalArgumentException("Supplied x coordinate exceeds image bounds");
        }
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("Supplied y coordinate exceeds image bounds");
        }
        return Pix.nativeGetPixel(this.mNativePix, x, y);
    }

    public void setPixel(int x, int y, @ColorInt int color) {
        if (this.mRecycled) {
            throw new IllegalStateException();
        }
        if (x < 0 || x >= this.getWidth()) {
            throw new IllegalArgumentException("Supplied x coordinate exceeds image bounds");
        }
        if (y < 0 || y >= this.getHeight()) {
            throw new IllegalArgumentException("Supplied y coordinate exceeds image bounds");
        }
        Pix.nativeSetPixel(this.mNativePix, x, y, color);
    }

    private static native int nativeGetRefCount(long var0);

    private static native long nativeCreatePix(int var0, int var1, int var2);

    private static native long nativeCreateFromData(byte[] var0, int var1, int var2, int var3);

    private static native byte[] nativeGetData(long var0);

    private static native long nativeClone(long var0);

    private static native long nativeCopy(long var0);

    private static native boolean nativeInvert(long var0);

    private static native void nativeDestroy(long var0);

    private static native boolean nativeGetDimensions(long var0, int[] var2);

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native int nativeGetDepth(long var0);

    private static native int nativeGetPixel(long var0, int var2, int var3);

    private static native void nativeSetPixel(long var0, int var2, int var3, int var4);

    private static native int nativeGetSpp(long var0);

    private static native int nativeGetInputFormat(long var0);

    static {
        System.loadLibrary("leptonica");
    }

    public static final class ImageFileFormat {
        public static final int IFF_UNKNOWN = 0;
        public static final int IFF_BMP = 1;
        public static final int IFF_JFIF_JPEG = 2;
        public static final int IFF_PNG = 3;
        public static final int IFF_TIFF = 4;
        public static final int IFF_TIFF_PACKBITS = 5;
        public static final int IFF_TIFF_RLE = 6;
        public static final int IFF_TIFF_G3 = 7;
        public static final int IFF_TIFF_G4 = 8;
        public static final int IFF_TIFF_LZW = 9;
        public static final int IFF_TIFF_ZIP = 10;
        public static final int IFF_PNM = 11;
        public static final int IFF_PS = 12;
        public static final int IFF_GIF = 13;
        public static final int IFF_JP2 = 14;
        public static final int IFF_WEBP = 15;
        public static final int IFF_LPDF = 16;
        public static final int IFF_TIFF_JPEG = 17;
        public static final int IFF_DEFAULT = 18;
        public static final int IFF_SPIX = 19;

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Format {
        }
    }
}

