/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.base.utils;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import org.jetbrains.annotations.NotNull;

public class BitmapUtils {
    public static Bitmap rotateBitmap(@NotNull Bitmap bitmap2, int rotation) {
        Matrix matrix = new Matrix();
        matrix.postRotate((float)rotation);
        Bitmap resizedBitmap = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)bitmap2.getWidth(), (int)bitmap2.getHeight(), (Matrix)matrix, (boolean)true);
        return resizedBitmap;
    }

    public static Bitmap scaleBitmapDown(Bitmap bitmap2, int maxDimension) {
        int originalWidth = bitmap2.getWidth();
        int originalHeight = bitmap2.getHeight();
        int resizedWidth = maxDimension;
        int resizedHeight = maxDimension;
        if (originalHeight > originalWidth) {
            resizedHeight = maxDimension;
            resizedWidth = (int)((float)resizedHeight * (float)originalWidth / (float)originalHeight);
        } else if (originalWidth > originalHeight) {
            resizedWidth = maxDimension;
            resizedHeight = (int)((float)resizedWidth * (float)originalHeight / (float)originalWidth);
        } else if (originalHeight == originalWidth) {
            resizedHeight = maxDimension;
            resizedWidth = maxDimension;
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap2, (int)resizedWidth, (int)resizedHeight, (boolean)false);
    }
}

