/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.base.view.drag;

import android.content.Context;
import android.content.res.Resources;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import androidx.core.view.MotionEventCompat;
import androidx.core.view.ViewCompat;
import androidx.core.widget.ScrollerCompat;
import androidx.recyclerview.widget.RecyclerView;

public class DragSelectTouchListener
implements RecyclerView.OnItemTouchListener {
    private static final String TAG = "DSTL";
    private boolean mIsActive;
    private int mStart;
    private int mEnd;
    private boolean mInTopSpot;
    private boolean mInBottomSpot;
    private int mScrollDistance;
    private float mScrollSpeedFactor;
    private float mLastX;
    private float mLastY;
    private int mLastStart;
    private int mLastEnd;
    private OnDragSelectListener mSelectListener;
    private RecyclerView mRecyclerView;
    private ScrollerCompat mScroller;
    private Runnable mScrollRunnable = new Runnable(){

        @Override
        public void run() {
            if (DragSelectTouchListener.this.mScroller != null && DragSelectTouchListener.this.mScroller.computeScrollOffset()) {
                DragSelectTouchListener.this.scrollBy(DragSelectTouchListener.this.mScrollDistance);
                ViewCompat.postOnAnimation((View)DragSelectTouchListener.this.mRecyclerView, (Runnable)DragSelectTouchListener.this.mScrollRunnable);
            }
        }
    };
    private int mTopBoundFrom;
    private int mTopBoundTo;
    private int mBottomBoundFrom;
    private int mBottomBoundTo;
    private int mMaxScrollDistance = 16;
    private int mAutoScrollDistance;
    private int mTouchRegionTopOffset;
    private int mTouchRegionBottomOffset;
    private boolean mScrollAboveTopRegion;
    private boolean mScrollBelowTopRegion;
    private boolean mDebug;

    public DragSelectTouchListener() {
        this.mAutoScrollDistance = (int)(Resources.getSystem().getDisplayMetrics().density * 56.0f);
        this.mTouchRegionTopOffset = 0;
        this.mTouchRegionBottomOffset = 0;
        this.mScrollAboveTopRegion = true;
        this.mScrollBelowTopRegion = true;
        this.mDebug = false;
        this.reset();
    }

    public DragSelectTouchListener withSelectListener(OnDragSelectListener selectListener) {
        this.mSelectListener = selectListener;
        return this;
    }

    public DragSelectTouchListener withMaxScrollDistance(int distance) {
        this.mMaxScrollDistance = distance;
        return this;
    }

    public DragSelectTouchListener withTouchRegion(int size) {
        this.mAutoScrollDistance = size;
        return this;
    }

    public DragSelectTouchListener withTopOffset(int distance) {
        this.mTouchRegionTopOffset = distance;
        return this;
    }

    public DragSelectTouchListener withBottomOffset(int distance) {
        this.mTouchRegionBottomOffset = distance;
        return this;
    }

    public DragSelectTouchListener withScrollAboveTopRegion(boolean enabled) {
        this.mScrollAboveTopRegion = enabled;
        return this;
    }

    public DragSelectTouchListener withScrollBelowTopRegion(boolean enabled) {
        this.mScrollBelowTopRegion = enabled;
        return this;
    }

    public DragSelectTouchListener withDebug(boolean enabled) {
        this.mDebug = enabled;
        return this;
    }

    public void startDragSelection(int position) {
        this.setIsActive(true);
        this.mStart = position;
        this.mEnd = position;
        this.mLastStart = position;
        this.mLastEnd = position;
        if (this.mSelectListener != null && this.mSelectListener instanceof OnAdvancedDragSelectListener) {
            ((OnAdvancedDragSelectListener)this.mSelectListener).onSelectionStarted(position);
        }
    }

    public boolean onInterceptTouchEvent(RecyclerView rv, MotionEvent e) {
        if (!this.mIsActive || rv.getAdapter().getItemCount() == 0) {
            return false;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)e);
        switch (action) {
            case 0: 
            case 5: {
                this.reset();
            }
        }
        this.mRecyclerView = rv;
        int height = rv.getHeight();
        this.mTopBoundFrom = 0 + this.mTouchRegionTopOffset;
        this.mTopBoundTo = 0 + this.mTouchRegionTopOffset + this.mAutoScrollDistance;
        this.mBottomBoundFrom = height + this.mTouchRegionBottomOffset - this.mAutoScrollDistance;
        this.mBottomBoundTo = height + this.mTouchRegionBottomOffset;
        return true;
    }

    public void startAutoScroll() {
        if (this.mRecyclerView == null) {
            return;
        }
        this.initScroller(this.mRecyclerView.getContext());
        if (this.mScroller.isFinished()) {
            this.mRecyclerView.removeCallbacks(this.mScrollRunnable);
            this.mScroller.startScroll(0, this.mScroller.getCurrY(), 0, 5000, 100000);
            ViewCompat.postOnAnimation((View)this.mRecyclerView, (Runnable)this.mScrollRunnable);
        }
    }

    private void initScroller(Context context) {
        if (this.mScroller == null) {
            this.mScroller = ScrollerCompat.create((Context)context, (Interpolator)new LinearInterpolator());
        }
    }

    public void stopAutoScroll() {
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            this.mRecyclerView.removeCallbacks(this.mScrollRunnable);
            this.mScroller.abortAnimation();
        }
    }

    public void onTouchEvent(RecyclerView rv, MotionEvent e) {
        if (!this.mIsActive) {
            return;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)e);
        switch (action) {
            case 2: {
                if (!this.mInTopSpot && !this.mInBottomSpot) {
                    this.updateSelectedRange(rv, e);
                }
                this.processAutoScroll(e);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                this.reset();
            }
        }
    }

    private void updateSelectedRange(RecyclerView rv, MotionEvent e) {
        this.updateSelectedRange(rv, e.getX(), e.getY());
    }

    private void updateSelectedRange(RecyclerView rv, float x, float y) {
        int position;
        View child = rv.findChildViewUnder(x, y);
        if (child != null && (position = rv.getChildAdapterPosition(child)) != -1 && this.mEnd != position) {
            this.mEnd = position;
            this.notifySelectRangeChange();
        }
    }

    private void processAutoScroll(MotionEvent event) {
        int y = (int)event.getY();
        if (this.mDebug) {
            Log.d((String)TAG, (String)("y = " + y + " | rv.height = " + this.mRecyclerView.getHeight() + " | mTopBoundFrom => mTopBoundTo = " + this.mTopBoundFrom + " => " + this.mTopBoundTo + " | mBottomBoundFrom => mBottomBoundTo = " + this.mBottomBoundFrom + " => " + this.mBottomBoundTo + " | mTouchRegionTopOffset = " + this.mTouchRegionTopOffset + " | mTouchRegionBottomOffset = " + this.mTouchRegionBottomOffset));
        }
        if (y >= this.mTopBoundFrom && y <= this.mTopBoundTo) {
            this.mLastX = event.getX();
            this.mLastY = event.getY();
            this.mScrollSpeedFactor = ((float)this.mTopBoundTo - (float)this.mTopBoundFrom - ((float)y - (float)this.mTopBoundFrom)) / ((float)this.mTopBoundTo - (float)this.mTopBoundFrom);
            this.mScrollDistance = (int)((float)this.mMaxScrollDistance * this.mScrollSpeedFactor * -1.0f);
            if (this.mDebug) {
                Log.d((String)TAG, (String)("SCROLL - mScrollSpeedFactor=" + this.mScrollSpeedFactor + " | mScrollDistance=" + this.mScrollDistance));
            }
            if (!this.mInTopSpot) {
                this.mInTopSpot = true;
                this.startAutoScroll();
            }
        } else if (this.mScrollAboveTopRegion && y < this.mTopBoundFrom) {
            this.mLastX = event.getX();
            this.mLastY = event.getY();
            this.mScrollDistance = this.mMaxScrollDistance * -1;
            if (!this.mInTopSpot) {
                this.mInTopSpot = true;
                this.startAutoScroll();
            }
        } else if (y >= this.mBottomBoundFrom && y <= this.mBottomBoundTo) {
            this.mLastX = event.getX();
            this.mLastY = event.getY();
            this.mScrollSpeedFactor = ((float)y - (float)this.mBottomBoundFrom) / ((float)this.mBottomBoundTo - (float)this.mBottomBoundFrom);
            this.mScrollDistance = (int)((float)this.mMaxScrollDistance * this.mScrollSpeedFactor);
            if (this.mDebug) {
                Log.d((String)TAG, (String)("SCROLL - mScrollSpeedFactor=" + this.mScrollSpeedFactor + " | mScrollDistance=" + this.mScrollDistance));
            }
            if (!this.mInBottomSpot) {
                this.mInBottomSpot = true;
                this.startAutoScroll();
            }
        } else if (this.mScrollBelowTopRegion && y > this.mBottomBoundTo) {
            this.mLastX = event.getX();
            this.mLastY = event.getY();
            this.mScrollDistance = this.mMaxScrollDistance;
            if (!this.mInTopSpot) {
                this.mInTopSpot = true;
                this.startAutoScroll();
            }
        } else {
            this.mInBottomSpot = false;
            this.mInTopSpot = false;
            this.mLastX = Float.MIN_VALUE;
            this.mLastY = Float.MIN_VALUE;
            this.stopAutoScroll();
        }
    }

    private void notifySelectRangeChange() {
        if (this.mSelectListener == null) {
            return;
        }
        if (this.mStart == -1 || this.mEnd == -1) {
            return;
        }
        int newStart = Math.min(this.mStart, this.mEnd);
        int newEnd = Math.max(this.mStart, this.mEnd);
        if (this.mLastStart == -1 || this.mLastEnd == -1) {
            if (newEnd - newStart == 1) {
                this.mSelectListener.onSelectChange(newStart, newStart, true);
            } else {
                this.mSelectListener.onSelectChange(newStart, newEnd, true);
            }
        } else {
            if (newStart > this.mLastStart) {
                this.mSelectListener.onSelectChange(this.mLastStart, newStart - 1, false);
            } else if (newStart < this.mLastStart) {
                this.mSelectListener.onSelectChange(newStart, this.mLastStart - 1, true);
            }
            if (newEnd > this.mLastEnd) {
                this.mSelectListener.onSelectChange(this.mLastEnd + 1, newEnd, true);
            } else if (newEnd < this.mLastEnd) {
                this.mSelectListener.onSelectChange(newEnd + 1, this.mLastEnd, false);
            }
        }
        this.mLastStart = newStart;
        this.mLastEnd = newEnd;
    }

    private void reset() {
        this.setIsActive(false);
        if (this.mSelectListener != null && this.mSelectListener instanceof OnAdvancedDragSelectListener) {
            ((OnAdvancedDragSelectListener)this.mSelectListener).onSelectionFinished(this.mEnd);
        }
        this.mStart = -1;
        this.mEnd = -1;
        this.mLastStart = -1;
        this.mLastEnd = -1;
        this.mInTopSpot = false;
        this.mInBottomSpot = false;
        this.mLastX = Float.MIN_VALUE;
        this.mLastY = Float.MIN_VALUE;
        this.stopAutoScroll();
    }

    public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
    }

    private void scrollBy(int distance) {
        int scrollDistance = distance > 0 ? Math.min(distance, this.mMaxScrollDistance) : Math.max(distance, -this.mMaxScrollDistance);
        this.mRecyclerView.scrollBy(0, scrollDistance);
        if (this.mLastX != Float.MIN_VALUE && this.mLastY != Float.MIN_VALUE) {
            this.updateSelectedRange(this.mRecyclerView, this.mLastX, this.mLastY);
        }
    }

    public void setIsActive(boolean isActive) {
        this.mIsActive = isActive;
    }

    public static interface OnDragSelectListener {
        public void onSelectChange(int var1, int var2, boolean var3);
    }

    public static interface OnAdvancedDragSelectListener
    extends OnDragSelectListener {
        public void onSelectionStarted(int var1);

        public void onSelectionFinished(int var1);
    }
}

