/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.engine.meter;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.talpa.translate.camera.view.CameraLogger;
import com.talpa.translate.camera.view.engine.action.ActionHolder;
import com.talpa.translate.camera.view.engine.meter.BaseReset;

@RequiresApi(value=21)
public class ExposureReset
extends BaseReset {
    private static final String TAG = ExposureReset.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int STATE_WAITING_LOCK = 0;

    public ExposureReset() {
        super(true);
    }

    @Override
    protected void onStarted(@NonNull ActionHolder holder, @Nullable MeteringRectangle area) {
        TotalCaptureResult lastResult;
        int maxRegions = this.readCharacteristic(CameraCharacteristics.CONTROL_MAX_REGIONS_AE, 0);
        if (area != null && maxRegions > 0) {
            holder.getBuilder(this).set(CaptureRequest.CONTROL_AE_REGIONS, (Object)new MeteringRectangle[]{area});
        }
        Integer trigger = (lastResult = holder.getLastResult(this)) == null ? null : (Integer)lastResult.get(CaptureResult.CONTROL_AE_PRECAPTURE_TRIGGER);
        LOG.i("onStarted:", "last precapture trigger is", trigger);
        if (trigger != null && trigger == 1) {
            LOG.i("onStarted:", "canceling precapture.");
            int newTrigger = Build.VERSION.SDK_INT >= 23 ? 2 : 0;
            holder.getBuilder(this).set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)newTrigger);
        }
        holder.getBuilder(this).set(CaptureRequest.CONTROL_AE_LOCK, (Object)true);
        holder.applyBuilder(this);
        this.setState(0);
    }

    @Override
    public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        super.onCaptureCompleted(holder, request, result);
        if (this.getState() == 0) {
            holder.getBuilder(this).set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
            holder.applyBuilder(this);
            this.setState(Integer.MAX_VALUE);
        }
    }
}

