package com.talpa.translate.base.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.viewpager.widget.PagerAdapter
import com.photo.translation.R

/**
 * Create by chenjunsheng on 2021/1/15
 */

enum class Feature {
    PHOTO_TRANSLATE, ITEM_RECOGNIZE
}

class FeatureAdapter(private val context: Context, private val features: List<Feature>) :
    PagerAdapter() {

    override fun instantiateItem(container: ViewGroup, position: Int): Any {
        val view = LayoutInflater.from(context).inflate(R.layout.feature_item, container, false)
        val title = view.findViewById<TextView>(R.id.title)
        when (features[position]) {
            Feature.PHOTO_TRANSLATE -> {
                title.setText(R.string.text_recognize_title)
            }
            Feature.ITEM_RECOGNIZE -> {
                title.setText(R.string.image_label_title)
            }
        }
        container.addView(view)
        return view
    }

    fun getItem(pos: Int): Feature {
        return features[pos]
    }

    override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
        if (`object` is View) {
            container.removeView(`object`)
        }
    }

    override fun getCount(): Int {
        return features.size
    }

    override fun isViewFromObject(view: View, `object`: Any): Boolean {
        return view == `object`
    }

    override fun getPageTitle(position: Int): CharSequence? {
        return when (features[position]) {
            Feature.PHOTO_TRANSLATE -> {
                context.getString(R.string.text_recognize_title)
            }
            Feature.ITEM_RECOGNIZE -> {
                context.getString(R.string.image_label_title)
            }
        }
    }

}