package com.talpa.translate.ocr

import android.graphics.Bitmap
import androidx.lifecycle.LiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.asLiveData
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.flow

/**
 * Create by chenjunsheng on 2021/3/17
 */
class CombineViewModel : ViewModel() {

    fun combine(source1: Bitmap, source2: Bitmap): LiveData<Bitmap> {
        return flow {
            emit(Utils.mergeBitmap(source1, source2))
        }.asLiveData(Dispatchers.IO)

    }
}