package com.talpa.translate.ocr

import android.graphics.Bitmap
import android.graphics.Rect
import com.talpa.translate.ocr.thirdpart.tesseract.TessBaseAPI.PageSegMode.PSM_SINGLE_BLOCK

/**
 * Create by chenjunsheng on 2020/8/5
 */
class OcrController : IOcrController {

    private var textRecognitionHelper: TextRecognitionHelper = TextRecognitionHelper()

    init {
        textRecognitionHelper.prepareTesseract("eng")
    }

    override fun setImage(bitmap: Bitmap) {
        textRecognitionHelper.setBitmap(bitmap, PSM_SINGLE_BLOCK)
    }

    override fun getTextRegions(): List<Rect> {
        return textRecognitionHelper.textRegions
    }

    override fun clearImage() {
        textRecognitionHelper.stop()
    }

    override fun destroy() {
        textRecognitionHelper.destroy()
    }


}