/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.surface.opengl.program;

import android.graphics.RectF;
import android.opengl.GLES20;
import com.talpa.translate.camera.surface.opengl.core.Egloo;
import com.talpa.translate.camera.surface.opengl.draw.Gl2dDrawable;
import com.talpa.translate.camera.surface.opengl.draw.GlDrawable;
import com.talpa.translate.camera.surface.opengl.extensions.BuffersKt;
import com.talpa.translate.camera.surface.opengl.program.GlProgram;
import com.talpa.translate.camera.surface.opengl.program.GlProgramLocation;
import com.talpa.translate.camera.surface.opengl.program.GlShader;
import com.talpa.translate.camera.surface.opengl.texture.GlTexture;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 62\u00020\u0001:\u00016BG\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tB;\b\u0017\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fB;\b\u0004\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000fJ8\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020\u000eH\u0014J\u0010\u00100\u001a\u0002012\u0006\u0010+\u001a\u000202H\u0016J\u0018\u00103\u001a\u0002012\u0006\u0010+\u001a\u0002022\u0006\u00104\u001a\u00020 H\u0016J\b\u00105\u001a\u000201H\u0016R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u0010\u0010%\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/talpa/translate/camera/surface/opengl/program/GlTextureProgram;", "Lcom/talpa/translate/camera/surface/opengl/program/GlProgram;", "vertexShader", "", "fragmentShader", "vertexPositionName", "vertexMvpMatrixName", "textureCoordsName", "textureTransformName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "handle", "", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "ownsHandle", "", "(IZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "lastDrawable", "Lcom/talpa/translate/camera/surface/opengl/draw/Gl2dDrawable;", "lastDrawableBounds", "Landroid/graphics/RectF;", "lastDrawableVersion", "texture", "Lcom/talpa/translate/camera/surface/opengl/texture/GlTexture;", "getTexture", "()Lcom/talpa/translate/camera/surface/opengl/texture/GlTexture;", "setTexture", "(Lcom/talpa/translate/camera/surface/opengl/texture/GlTexture;)V", "textureCoordsBuffer", "Ljava/nio/FloatBuffer;", "textureCoordsHandle", "Lcom/talpa/translate/camera/surface/opengl/program/GlProgramLocation;", "textureTransform", "", "getTextureTransform", "()[F", "setTextureTransform", "([F)V", "textureTransformHandle", "vertexMvpMatrixHandle", "vertexPositionHandle", "computeTextureCoordinate", "", "vertex", "drawable", "value", "min", "max", "horizontal", "onPostDraw", "", "Lcom/talpa/translate/camera/surface/opengl/draw/GlDrawable;", "onPreDraw", "modelViewProjectionMatrix", "release", "Companion", "translation_googleRelease"})
public class GlTextureProgram
extends GlProgram {
    @NotNull
    private float[] textureTransform;
    private final GlProgramLocation textureTransformHandle;
    private FloatBuffer textureCoordsBuffer;
    private final GlProgramLocation textureCoordsHandle;
    private final GlProgramLocation vertexPositionHandle;
    private final GlProgramLocation vertexMvpMatrixHandle;
    private final RectF lastDrawableBounds;
    private int lastDrawableVersion;
    private Gl2dDrawable lastDrawable;
    @Nullable
    private GlTexture texture;
    @NotNull
    private static final String TAG;
    @NotNull
    public static final String SIMPLE_VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n";
    @NotNull
    public static final String SIMPLE_FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final float[] getTextureTransform() {
        return this.textureTransform;
    }

    public final void setTextureTransform(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.textureTransform = fArray;
    }

    @Nullable
    public final GlTexture getTexture() {
        return this.texture;
    }

    public final void setTexture(@Nullable GlTexture glTexture) {
        this.texture = glTexture;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onPreDraw(@NotNull GlDrawable drawable2, @NotNull float[] modelViewProjectionMatrix) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
            Intrinsics.checkNotNullParameter((Object)modelViewProjectionMatrix, (String)"modelViewProjectionMatrix");
            super.onPreDraw(drawable2, modelViewProjectionMatrix);
            if (!(drawable2 instanceof Gl2dDrawable)) {
                throw (Throwable)new RuntimeException("GlTextureProgram only supports 2D drawables.");
            }
            GlTexture glTexture = this.texture;
            if (glTexture != null) {
                glTexture.bind();
            }
            GlProgramLocation glProgramLocation = this.vertexMvpMatrixHandle;
            boolean bl = false;
            boolean bl2 = false;
            GlProgramLocation it = glProgramLocation;
            boolean bl3 = false;
            GLES20.glUniformMatrix4fv((int)it.getValue(), (int)1, (boolean)false, (float[])modelViewProjectionMatrix, (int)0);
            Egloo.checkGlError("glUniformMatrix4fv");
            GlProgramLocation glProgramLocation2 = this.textureTransformHandle;
            if (glProgramLocation2 != null) {
                glProgramLocation = glProgramLocation2;
                bl = false;
                bl2 = false;
                it = glProgramLocation;
                boolean bl4 = false;
                GLES20.glUniformMatrix4fv((int)it.getValue(), (int)1, (boolean)false, (float[])this.textureTransform, (int)0);
                Egloo.checkGlError("glUniformMatrix4fv");
            }
            glProgramLocation = this.vertexPositionHandle;
            bl = false;
            bl2 = false;
            it = glProgramLocation;
            boolean bl5 = false;
            GLES20.glEnableVertexAttribArray((int)it.getValue());
            Egloo.checkGlError("glEnableVertexAttribArray");
            GLES20.glVertexAttribPointer((int)it.getValue(), (int)2, (int)5126, (boolean)false, (int)drawable2.getVertexStride(), (Buffer)drawable2.getVertexArray());
            Egloo.checkGlError("glVertexAttribPointer");
            GlProgramLocation glProgramLocation3 = this.textureCoordsHandle;
            if (glProgramLocation3 == null) break block7;
            glProgramLocation = glProgramLocation3;
            bl = false;
            bl2 = false;
            it = glProgramLocation;
            boolean bl6 = false;
            if (Intrinsics.areEqual((Object)drawable2, (Object)this.lastDrawable) ^ true || drawable2.getVertexArrayVersion() != this.lastDrawableVersion) {
                this.lastDrawable = (Gl2dDrawable)drawable2;
                this.lastDrawableVersion = drawable2.getVertexArrayVersion();
                ((Gl2dDrawable)drawable2).getBounds(this.lastDrawableBounds);
                int coordinates = drawable2.getVertexCount() * 2;
                if (this.textureCoordsBuffer.capacity() < coordinates) {
                    this.textureCoordsBuffer = BuffersKt.floatBufferOf(coordinates);
                }
                this.textureCoordsBuffer.clear();
                this.textureCoordsBuffer.limit(coordinates);
                int n = 0;
                int n2 = coordinates;
                while (n < n2) {
                    void i;
                    boolean isX = i % 2 == false;
                    float value = drawable2.getVertexArray().get((int)i);
                    float min = isX ? this.lastDrawableBounds.left : this.lastDrawableBounds.bottom;
                    float max = isX ? this.lastDrawableBounds.right : this.lastDrawableBounds.top;
                    float texValue = this.computeTextureCoordinate((int)(i / 2), (Gl2dDrawable)drawable2, value, min, max, isX);
                    this.textureCoordsBuffer.put((int)i, texValue);
                    ++i;
                }
            } else {
                this.textureCoordsBuffer.rewind();
            }
            GLES20.glEnableVertexAttribArray((int)it.getValue());
            Egloo.checkGlError("glEnableVertexAttribArray");
            GLES20.glVertexAttribPointer((int)it.getValue(), (int)2, (int)5126, (boolean)false, (int)drawable2.getVertexStride(), (Buffer)this.textureCoordsBuffer);
            Egloo.checkGlError("glVertexAttribPointer");
        }
    }

    protected float computeTextureCoordinate(int vertex, @NotNull Gl2dDrawable drawable2, float value, float min, float max, boolean horizontal) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        float fraction = (value - min) / (max - min);
        return 0.0f + fraction * 1.0f;
    }

    @Override
    public void onPostDraw(@NotNull GlDrawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        super.onPostDraw(drawable2);
        GlProgramLocation glProgramLocation = this.vertexPositionHandle;
        boolean bl = false;
        boolean bl2 = false;
        GlProgramLocation it = glProgramLocation;
        boolean bl3 = false;
        GLES20.glDisableVertexAttribArray((int)it.getValue());
        GlProgramLocation glProgramLocation2 = this.textureCoordsHandle;
        if (glProgramLocation2 != null) {
            glProgramLocation = glProgramLocation2;
            bl = false;
            bl2 = false;
            it = glProgramLocation;
            boolean bl4 = false;
            GLES20.glDisableVertexAttribArray((int)it.getValue());
        }
        GlTexture glTexture = this.texture;
        if (glTexture != null) {
            glTexture.unbind();
        }
        Egloo.checkGlError("onPostDraw end");
    }

    @Override
    public void release() {
        super.release();
        GlTexture glTexture = this.texture;
        if (glTexture != null) {
            glTexture.release();
        }
        this.texture = null;
    }

    protected GlTextureProgram(int handle, boolean ownsHandle, @NotNull String vertexPositionName, @NotNull String vertexMvpMatrixName, @Nullable String textureCoordsName, @Nullable String textureTransformName) {
        GlProgramLocation glProgramLocation;
        GlProgramLocation glProgramLocation2;
        GlProgramLocation glProgramLocation3;
        String it;
        GlTextureProgram glTextureProgram;
        boolean bl;
        boolean bl2;
        String string2;
        Intrinsics.checkNotNullParameter((Object)vertexPositionName, (String)"vertexPositionName");
        Intrinsics.checkNotNullParameter((Object)vertexMvpMatrixName, (String)"vertexMvpMatrixName");
        super(handle, ownsHandle, new GlShader[0]);
        this.textureTransform = (float[])Egloo.IDENTITY_MATRIX.clone();
        GlTextureProgram glTextureProgram2 = this;
        String string3 = textureTransformName;
        if (string3 != null) {
            string2 = string3;
            bl2 = false;
            bl = false;
            String string4 = string2;
            glTextureProgram = glTextureProgram2;
            boolean bl3 = false;
            glProgramLocation3 = this.getUniformHandle(it);
            glTextureProgram2 = glTextureProgram;
            glProgramLocation2 = glProgramLocation3;
        } else {
            glProgramLocation2 = null;
        }
        glTextureProgram2.textureTransformHandle = glProgramLocation2;
        this.textureCoordsBuffer = BuffersKt.floatBufferOf(8);
        GlTextureProgram glTextureProgram3 = this;
        String string5 = textureCoordsName;
        if (string5 != null) {
            string2 = string5;
            bl2 = false;
            bl = false;
            it = string2;
            glTextureProgram = glTextureProgram3;
            boolean bl4 = false;
            glProgramLocation3 = this.getAttribHandle(it);
            glTextureProgram3 = glTextureProgram;
            glProgramLocation = glProgramLocation3;
        } else {
            glProgramLocation = null;
        }
        glTextureProgram3.textureCoordsHandle = glProgramLocation;
        this.vertexPositionHandle = this.getAttribHandle(vertexPositionName);
        this.vertexMvpMatrixHandle = this.getUniformHandle(vertexMvpMatrixName);
        this.lastDrawableBounds = new RectF();
        this.lastDrawableVersion = -1;
    }

    @JvmOverloads
    public GlTextureProgram(@NotNull String vertexShader, @NotNull String fragmentShader, @NotNull String vertexPositionName, @NotNull String vertexMvpMatrixName, @Nullable String textureCoordsName, @Nullable String textureTransformName) {
        Intrinsics.checkNotNullParameter((Object)vertexShader, (String)"vertexShader");
        Intrinsics.checkNotNullParameter((Object)fragmentShader, (String)"fragmentShader");
        Intrinsics.checkNotNullParameter((Object)vertexPositionName, (String)"vertexPositionName");
        Intrinsics.checkNotNullParameter((Object)vertexMvpMatrixName, (String)"vertexMvpMatrixName");
        this(GlProgram.Companion.create(vertexShader, fragmentShader), true, vertexPositionName, vertexMvpMatrixName, textureCoordsName, textureTransformName);
    }

    public /* synthetic */ GlTextureProgram(String string2, String string3, String string4, String string5, String string6, String string7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string2 = SIMPLE_VERTEX_SHADER;
        }
        if ((n & 2) != 0) {
            string3 = SIMPLE_FRAGMENT_SHADER;
        }
        if ((n & 4) != 0) {
            string4 = "aPosition";
        }
        if ((n & 8) != 0) {
            string5 = "uMVPMatrix";
        }
        if ((n & 0x10) != 0) {
            string6 = "aTextureCoord";
        }
        if ((n & 0x20) != 0) {
            string7 = "uTexMatrix";
        }
        this(string2, string3, string4, string5, string6, string7);
    }

    @JvmOverloads
    public GlTextureProgram(@NotNull String vertexShader, @NotNull String fragmentShader, @NotNull String vertexPositionName, @NotNull String vertexMvpMatrixName, @Nullable String textureCoordsName) {
        this(vertexShader, fragmentShader, vertexPositionName, vertexMvpMatrixName, textureCoordsName, null, 32, null);
    }

    @JvmOverloads
    public GlTextureProgram(@NotNull String vertexShader, @NotNull String fragmentShader, @NotNull String vertexPositionName, @NotNull String vertexMvpMatrixName) {
        this(vertexShader, fragmentShader, vertexPositionName, vertexMvpMatrixName, null, null, 48, null);
    }

    @JvmOverloads
    public GlTextureProgram(@NotNull String vertexShader, @NotNull String fragmentShader, @NotNull String vertexPositionName) {
        this(vertexShader, fragmentShader, vertexPositionName, null, null, null, 56, null);
    }

    @JvmOverloads
    public GlTextureProgram(@NotNull String vertexShader, @NotNull String fragmentShader) {
        this(vertexShader, fragmentShader, null, null, null, null, 60, null);
    }

    @JvmOverloads
    public GlTextureProgram(@NotNull String vertexShader) {
        this(vertexShader, null, null, null, null, null, 62, null);
    }

    @JvmOverloads
    public GlTextureProgram() {
        this(null, null, null, null, null, null, 63, null);
    }

    @JvmOverloads
    public GlTextureProgram(int handle, @NotNull String vertexPositionName, @NotNull String vertexMvpMatrixName, @Nullable String textureCoordsName, @Nullable String textureTransformName) {
        Intrinsics.checkNotNullParameter((Object)vertexPositionName, (String)"vertexPositionName");
        Intrinsics.checkNotNullParameter((Object)vertexMvpMatrixName, (String)"vertexMvpMatrixName");
        this(handle, false, vertexPositionName, vertexMvpMatrixName, textureCoordsName, textureTransformName);
    }

    public /* synthetic */ GlTextureProgram(int n, String string2, String string3, String string4, String string5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = "aPosition";
        }
        if ((n2 & 4) != 0) {
            string3 = "uMVPMatrix";
        }
        if ((n2 & 8) != 0) {
            string4 = "aTextureCoord";
        }
        if ((n2 & 0x10) != 0) {
            string5 = "uTexMatrix";
        }
        this(n, string2, string3, string4, string5);
    }

    @JvmOverloads
    public GlTextureProgram(int handle, @NotNull String vertexPositionName, @NotNull String vertexMvpMatrixName, @Nullable String textureCoordsName) {
        this(handle, vertexPositionName, vertexMvpMatrixName, textureCoordsName, null, 16, null);
    }

    @JvmOverloads
    public GlTextureProgram(int handle, @NotNull String vertexPositionName, @NotNull String vertexMvpMatrixName) {
        this(handle, vertexPositionName, vertexMvpMatrixName, null, null, 24, null);
    }

    @JvmOverloads
    public GlTextureProgram(int handle, @NotNull String vertexPositionName) {
        this(handle, vertexPositionName, null, null, null, 28, null);
    }

    @JvmOverloads
    public GlTextureProgram(int handle) {
        this(handle, null, null, null, null, 30, null);
    }

    static {
        Companion = new Companion(null);
        String string2 = GlTextureProgram.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GlTextureProgram::class.java.simpleName");
        TAG = string2;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/talpa/translate/camera/surface/opengl/program/GlTextureProgram$Companion;", "", "()V", "SIMPLE_FRAGMENT_SHADER", "", "SIMPLE_VERTEX_SHADER", "TAG", "getTAG$translation_googleRelease$annotations", "getTAG$translation_googleRelease", "()Ljava/lang/String;", "translation_googleRelease"})
    public static final class Companion {
        public static /* synthetic */ void getTAG$translation_googleRelease$annotations() {
        }

        @NotNull
        public final String getTAG$translation_googleRelease() {
            return TAG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

