/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.preview;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.talpa.translate.camera.view.CameraLogger;
import com.talpa.translate.camera.view.size.Size;

public abstract class CameraPreview<T extends View, Output> {
    protected static final CameraLogger LOG = CameraLogger.create(CameraPreview.class.getSimpleName());
    @VisibleForTesting
    CropCallback mCropCallback;
    private SurfaceCallback mSurfaceCallback;
    private T mView;
    protected boolean mCropping;
    protected int mOutputSurfaceWidth;
    protected int mOutputSurfaceHeight;
    protected int mInputStreamWidth;
    protected int mInputStreamHeight;
    protected int mDrawRotation;

    public CameraPreview(@NonNull Context context, @NonNull ViewGroup parent) {
        this.mView = this.onCreateView(context, parent);
    }

    public void setSurfaceCallback(@Nullable SurfaceCallback callback) {
        if (this.hasSurface() && this.mSurfaceCallback != null) {
            this.mSurfaceCallback.onSurfaceDestroyed();
        }
        this.mSurfaceCallback = callback;
        if (this.hasSurface() && this.mSurfaceCallback != null) {
            this.mSurfaceCallback.onSurfaceAvailable();
        }
    }

    @NonNull
    protected abstract T onCreateView(@NonNull Context var1, @NonNull ViewGroup var2);

    @NonNull
    public final T getView() {
        return this.mView;
    }

    @NonNull
    public abstract View getRootView();

    @NonNull
    public abstract Output getOutput();

    @NonNull
    public abstract Class<Output> getOutputClass();

    public void setStreamSize(int width, int height) {
        LOG.i("setStreamSize:", "desiredW=", width, "desiredH=", height);
        this.mInputStreamWidth = width;
        this.mInputStreamHeight = height;
        if (this.mInputStreamWidth > 0 && this.mInputStreamHeight > 0) {
            this.crop(this.mCropCallback);
        }
    }

    @VisibleForTesting
    @NonNull
    final Size getStreamSize() {
        return new Size(this.mInputStreamWidth, this.mInputStreamHeight);
    }

    @NonNull
    public final Size getSurfaceSize() {
        return new Size(this.mOutputSurfaceWidth, this.mOutputSurfaceHeight);
    }

    public final boolean hasSurface() {
        return this.mOutputSurfaceWidth > 0 && this.mOutputSurfaceHeight > 0;
    }

    protected final void dispatchOnSurfaceAvailable(int width, int height) {
        LOG.i("dispatchOnSurfaceAvailable:", "w=", width, "h=", height);
        this.mOutputSurfaceWidth = width;
        this.mOutputSurfaceHeight = height;
        if (this.mOutputSurfaceWidth > 0 && this.mOutputSurfaceHeight > 0) {
            this.crop(this.mCropCallback);
        }
        if (this.mSurfaceCallback != null) {
            this.mSurfaceCallback.onSurfaceAvailable();
        }
    }

    protected final void dispatchOnSurfaceSizeChanged(int width, int height) {
        LOG.i("dispatchOnSurfaceSizeChanged:", "w=", width, "h=", height);
        if (width != this.mOutputSurfaceWidth || height != this.mOutputSurfaceHeight) {
            this.mOutputSurfaceWidth = width;
            this.mOutputSurfaceHeight = height;
            if (width > 0 && height > 0) {
                this.crop(this.mCropCallback);
            }
            if (this.mSurfaceCallback != null) {
                this.mSurfaceCallback.onSurfaceChanged();
            }
        }
    }

    protected final void dispatchOnSurfaceDestroyed() {
        this.mOutputSurfaceWidth = 0;
        this.mOutputSurfaceHeight = 0;
        if (this.mSurfaceCallback != null) {
            this.mSurfaceCallback.onSurfaceDestroyed();
        }
    }

    public void onResume() {
    }

    public void onPause() {
    }

    @CallSuper
    public void onDestroy() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            this.onDestroyView();
        } else {
            Handler ui = new Handler(Looper.getMainLooper());
            final TaskCompletionSource task = new TaskCompletionSource();
            ui.post(new Runnable(){

                @Override
                public void run() {
                    CameraPreview.this.onDestroyView();
                    task.setResult(null);
                }
            });
            try {
                Tasks.await((Task)task.getTask());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @UiThread
    protected void onDestroyView() {
        View root = this.getRootView();
        ViewParent parent = root.getParent();
        if (parent instanceof ViewGroup) {
            ((ViewGroup)parent).removeView(root);
        }
    }

    protected void crop(@Nullable CropCallback callback) {
        if (callback != null) {
            callback.onCrop();
        }
    }

    public boolean supportsCropping() {
        return false;
    }

    public boolean isCropping() {
        return this.mCropping;
    }

    public void setDrawRotation(int drawRotation) {
        this.mDrawRotation = drawRotation;
    }

    protected static interface CropCallback {
        public void onCrop();
    }

    public static interface SurfaceCallback {
        public void onSurfaceAvailable();

        public void onSurfaceChanged();

        public void onSurfaceDestroyed();
    }
}

