package com.talpa.translate.base.state

import android.graphics.Bitmap
import android.view.MotionEvent
import android.view.View
import androidx.core.os.LocaleListCompat
import com.talpa.translate.base.utils.CustomLocale

/**
 * Create by chenjunsheng on 2021/1/15
 */
interface PhotoMLState {

    fun onPictureTaken(
        bitmap: Bitmap,
        sourceLanguage: String,
        targetLanguage: String
    )

    fun enterState()

    fun getSupportSourceLanguage(): LocaleListCompat

    fun getSupportTargetLanguage(): LocaleListCompat

    fun changeLanguageAfter(sourceLocale: CustomLocale, targetLocale: CustomLocale)

    fun previewTouchAction(view: View, event: MotionEvent) : Boolean

}