package com.talpa.translate.base.utils

import android.content.Context
import com.google.mlkit.common.MlKitException
import com.talpa.translate.camera.CameraFragment
import java.io.IOException

/**
 * Create by chenjunsheng on 2020/5/8
 */

fun pickerClickedEvent(context: Context, state: Int) {
    when(state) {
        CameraFragment.STATE_CAMERA -> {
            logEvent(
                context,
                PT_lan_click,
                type,
                type_initialize
            )
        }
        CameraFragment.STATE_RESULT_FROM_CAMERA_SUCCESS -> {
            logEvent(
                context,
                PT_lan_click,
                type,
                type_camera_end
            )
        }
        CameraFragment.STATE_RESULT_FROM_GALLERY_SUCCESS -> {
            logEvent(
                context,
                PT_lan_click,
                type,
                type_gallery_end
            )
        }
        /*CameraFragment.STATE_CROP_FROM_GALLERY -> {
            logEvent(
                PT_lan_click,
                type,
                type_gallery
            )
        }
        CameraFragment.STATE_CROP_FROM_CAMERA -> {
            logEvent(
                PT_lan_click,
                type,
                type_camera
            )
        }*/
    }
}

fun changeLanguageEvent(context: Context, source: String, target: String) {
    logEvent(
        context,
        PT_lan_click_success,
        source_target_language,
        "${source}&${target}"
    )
}

fun translationFailEvent(context: Context, state: Int, throwable: Throwable?) {
    when(state) {
        CameraFragment.STATE_RESULT_FROM_CAMERA_FAIL -> {
            when (throwable) {
                is MlKitException -> {
                    logEvent(
                        context,
                        PT__camera_click_fail,
                        errorcode,
                        TIMEOUT
                    )
                }
                is IOException -> {
                    logEvent(
                        context,
                        PT__camera_click_fail,
                        errorcode,
                        NETWORK_PROBLEM
                    )
                }
                else -> {
                    logEvent(
                        context,
                        PT__camera_click_fail,
                        errorcode,
                        TRANSLATION_FAIL
                    )
                }
            }
        }
        CameraFragment.STATE_RESULT_FROM_GALLERY_FAIL -> {
            when (throwable) {
                is MlKitException -> {
                    logEvent(
                        context,
                        PT__gallery_click_fail,
                        errorcode,
                        TIMEOUT
                    )
                }
                is IOException -> {
                    logEvent(
                        context,
                        PT__gallery_click_fail,
                        errorcode,
                        NETWORK_PROBLEM
                    )
                }
                else -> {
                    logEvent(
                        context,
                        PT__gallery_click_fail,
                        errorcode,
                        TRANSLATION_FAIL
                    )
                }
            }

        }
    }
}