package com.talpa.translate.ocr.result

import android.content.res.Configuration
import android.os.Bundle
import androidx.activity.viewModels
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import com.gyf.immersionbar.ktx.immersionBar
import com.photo.translation.R
import com.talpa.translate.camera.COMPLETE_RESULT


/**
 * Create by chenjunsheng on 2020/10/12
 */
class ContrastActivity : AppCompatActivity(R.layout.contrast_activity_layout) {

    private val mContrastViewModel by viewModels<ContrastViewModel> {
        object : ViewModelProvider.Factory {
            override fun <T : ViewModel> create(modelClass: Class<T>): T {
                return ContrastViewModel() as T
            }
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val currentNightMode = resources.configuration.uiMode and Configuration.UI_MODE_NIGHT_MASK
        immersionBar {
            fitsSystemWindows(true)
            statusBarDarkFont(
                when (currentNightMode) {
                    Configuration.UI_MODE_NIGHT_NO -> {
                        true
                    } // Night mode is not active, we're using the light theme
                    else -> {
                        false
                    } // Night mode is active, we're using dark theme
                }
            )
            statusBarColor(R.color.actionbar_background_color)
        }

        intent.extras.let {
            val completeResult = it?.getBinder(COMPLETE_RESULT) as? CompleteTransfer
            completeResult?.let { transfer ->
                dealData(transfer)
            }

        }
    }

    private fun dealData(completeTransfer: CompleteTransfer) {
        val completeResult = completeTransfer.completeResult ?: return
        mContrastViewModel.updateResult(completeResult)
    }
}