/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.surface.opengl.program;

import android.graphics.Color;
import android.opengl.GLES20;
import androidx.annotation.ColorInt;
import com.talpa.translate.camera.surface.opengl.core.Egloo;
import com.talpa.translate.camera.surface.opengl.draw.GlDrawable;
import com.talpa.translate.camera.surface.opengl.program.GlProgram;
import com.talpa.translate.camera.surface.opengl.program.GlProgramLocation;
import java.nio.Buffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0010\u0010\b\u001a\u00020\u000f2\b\b\u0001\u0010\u0003\u001a\u00020\u0014R \u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/talpa/translate/camera/surface/opengl/program/GlFlatProgram;", "Lcom/talpa/translate/camera/surface/opengl/program/GlProgram;", "()V", "color", "", "getColor$annotations", "getColor", "()[F", "setColor", "([F)V", "fragmentColorHandle", "Lcom/talpa/translate/camera/surface/opengl/program/GlProgramLocation;", "vertexMvpMatrixHandle", "vertexPositionHandle", "onPostDraw", "", "drawable", "Lcom/talpa/translate/camera/surface/opengl/draw/GlDrawable;", "onPreDraw", "modelViewProjectionMatrix", "", "Companion", "translation_googleRelease"})
public class GlFlatProgram
extends GlProgram {
    private final GlProgramLocation vertexPositionHandle = this.getAttribHandle("aPosition");
    private final GlProgramLocation vertexMvpMatrixHandle = this.getUniformHandle("uMVPMatrix");
    private final GlProgramLocation fragmentColorHandle = this.getUniformHandle("uColor");
    @NotNull
    private float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    @NotNull
    private static final String TAG;
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nattribute vec4 aPosition;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n}\n";
    private static final String FRAGMENT_SHADER = "precision mediump float;\nuniform vec4 uColor;\nvoid main() {\n    gl_FragColor = uColor;\n}\n";
    public static final Companion Companion;

    public final void setColor(@ColorInt int color2) {
        this.color = new float[]{(float)Color.red((int)color2) / 255.0f, (float)Color.green((int)color2) / 255.0f, (float)Color.blue((int)color2) / 255.0f, (float)Color.alpha((int)color2) / 255.0f};
    }

    public static /* synthetic */ void getColor$annotations() {
    }

    @NotNull
    public final float[] getColor() {
        return this.color;
    }

    public final void setColor(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.color = fArray;
    }

    @Override
    public void onPreDraw(@NotNull GlDrawable drawable, @NotNull float[] modelViewProjectionMatrix) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)modelViewProjectionMatrix, (String)"modelViewProjectionMatrix");
        super.onPreDraw(drawable, modelViewProjectionMatrix);
        GLES20.glUniformMatrix4fv((int)this.vertexMvpMatrixHandle.getValue(), (int)1, (boolean)false, (float[])modelViewProjectionMatrix, (int)0);
        Egloo.checkGlError("glUniformMatrix4fv");
        GLES20.glUniform4fv((int)this.fragmentColorHandle.getValue(), (int)1, (float[])this.color, (int)0);
        Egloo.checkGlError("glUniform4fv");
        GLES20.glEnableVertexAttribArray((int)this.vertexPositionHandle.getValue());
        Egloo.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.vertexPositionHandle.getValue(), (int)drawable.getCoordsPerVertex(), (int)5126, (boolean)false, (int)drawable.getVertexStride(), (Buffer)drawable.getVertexArray());
        Egloo.checkGlError("glVertexAttribPointer");
    }

    @Override
    public void onPostDraw(@NotNull GlDrawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        super.onPostDraw(drawable);
        GLES20.glDisableVertexAttribArray((int)this.vertexPositionHandle.getValue());
    }

    public GlFlatProgram() {
        super(VERTEX_SHADER, FRAGMENT_SHADER);
    }

    static {
        Companion = new Companion(null);
        String string = GlFlatProgram.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GlFlatProgram::class.java.simpleName");
        TAG = string;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/talpa/translate/camera/surface/opengl/program/GlFlatProgram$Companion;", "", "()V", "FRAGMENT_SHADER", "", "TAG", "getTAG$translation_googleRelease$annotations", "getTAG$translation_googleRelease", "()Ljava/lang/String;", "VERTEX_SHADER", "translation_googleRelease"})
    public static final class Companion {
        public static /* synthetic */ void getTAG$translation_googleRelease$annotations() {
        }

        @NotNull
        public final String getTAG$translation_googleRelease() {
            return TAG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

