/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.engine.metering;

import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import androidx.annotation.NonNull;
import com.talpa.translate.camera.view.CameraLogger;
import com.talpa.translate.camera.view.engine.offset.Angles;
import com.talpa.translate.camera.view.engine.offset.Axis;
import com.talpa.translate.camera.view.engine.offset.Reference;
import com.talpa.translate.camera.view.metering.MeteringTransform;
import com.talpa.translate.camera.view.size.Size;

public class Camera1MeteringTransform
implements MeteringTransform<Camera.Area> {
    protected static final String TAG = Camera1MeteringTransform.class.getSimpleName();
    protected static final CameraLogger LOG = CameraLogger.create(TAG);
    private final int displayToSensor;
    private final Size previewSize;

    public Camera1MeteringTransform(@NonNull Angles angles, @NonNull Size previewSize) {
        this.displayToSensor = -angles.offset(Reference.SENSOR, Reference.VIEW, Axis.ABSOLUTE);
        this.previewSize = previewSize;
    }

    @Override
    @NonNull
    public PointF transformMeteringPoint(@NonNull PointF point) {
        PointF scaled = new PointF();
        scaled.x = -1000.0f + point.x / (float)this.previewSize.getWidth() * 2000.0f;
        scaled.y = -1000.0f + point.y / (float)this.previewSize.getHeight() * 2000.0f;
        PointF rotated = new PointF();
        double theta = (double)this.displayToSensor * Math.PI / 180.0;
        rotated.x = (float)((double)scaled.x * Math.cos(theta) - (double)scaled.y * Math.sin(theta));
        rotated.y = (float)((double)scaled.x * Math.sin(theta) + (double)scaled.y * Math.cos(theta));
        LOG.i("scaled:", scaled, "rotated:", rotated);
        return rotated;
    }

    @Override
    @NonNull
    public Camera.Area transformMeteringRegion(@NonNull RectF region, int weight) {
        Rect rect = new Rect();
        region.round(rect);
        return new Camera.Area(rect, weight);
    }
}

