/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.translate.camera.view.video.encoding;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaFormat;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.talpa.translate.camera.view.CameraLogger;
import com.talpa.translate.camera.view.internal.WorkerHandler;
import com.talpa.translate.camera.view.video.encoding.EncoderThread;
import com.talpa.translate.camera.view.video.encoding.InputBuffer;
import com.talpa.translate.camera.view.video.encoding.MediaCodecBuffers;
import com.talpa.translate.camera.view.video.encoding.MediaEncoderEngine;
import com.talpa.translate.camera.view.video.encoding.OutputBuffer;
import com.talpa.translate.camera.view.video.encoding.OutputBufferPool;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@RequiresApi(api=18)
public abstract class MediaEncoder {
    private static final String TAG = MediaEncoder.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final int INPUT_TIMEOUT_US = 0;
    private static final int OUTPUT_TIMEOUT_US = 0;
    private static final int STATE_NONE = 0;
    private static final int STATE_PREPARING = 1;
    private static final int STATE_PREPARED = 2;
    private static final int STATE_STARTING = 3;
    private static final int STATE_STARTED = 4;
    private static final int STATE_LIMIT_REACHED = 5;
    private static final int STATE_STOPPING = 6;
    private static final int STATE_STOPPED = 7;
    private int mState = 0;
    private final String mName;
    protected MediaCodec mMediaCodec;
    protected WorkerHandler mWorker;
    private MediaEncoderEngine.Controller mController;
    private int mTrackIndex;
    private OutputBufferPool mOutputBufferPool;
    private MediaCodec.BufferInfo mBufferInfo;
    private MediaCodecBuffers mBuffers;
    private final Map<String, AtomicInteger> mPendingEvents = new HashMap<String, AtomicInteger>();
    private long mMaxLengthUs;
    private boolean mMaxLengthReached;
    private long mStartTimeMillis = 0L;
    private long mFirstTimeUs = Long.MIN_VALUE;
    private long mLastTimeUs = 0L;
    private long mDebugSetStateTimestamp = Long.MIN_VALUE;

    protected MediaEncoder(@NonNull String name) {
        this.mName = name;
    }

    private void setState(int newState) {
        if (this.mDebugSetStateTimestamp == Long.MIN_VALUE) {
            this.mDebugSetStateTimestamp = System.currentTimeMillis();
        }
        long millis = System.currentTimeMillis() - this.mDebugSetStateTimestamp;
        this.mDebugSetStateTimestamp = System.currentTimeMillis();
        String newStateName = null;
        switch (newState) {
            case 0: {
                newStateName = "NONE";
                break;
            }
            case 1: {
                newStateName = "PREPARING";
                break;
            }
            case 2: {
                newStateName = "PREPARED";
                break;
            }
            case 3: {
                newStateName = "STARTING";
                break;
            }
            case 4: {
                newStateName = "STARTED";
                break;
            }
            case 5: {
                newStateName = "LIMIT_REACHED";
                break;
            }
            case 6: {
                newStateName = "STOPPING";
                break;
            }
            case 7: {
                newStateName = "STOPPED";
            }
        }
        LOG.w(this.mName, "setState:", newStateName, "millisSinceLastState:", millis);
        this.mState = newState;
    }

    final void prepare(final @NonNull MediaEncoderEngine.Controller controller, final long maxLengthUs) {
        if (this.mState >= 1) {
            LOG.e(this.mName, "Wrong state while preparing. Aborting.", this.mState);
            return;
        }
        this.mController = controller;
        this.mBufferInfo = new MediaCodec.BufferInfo();
        this.mMaxLengthUs = maxLengthUs;
        this.mWorker = WorkerHandler.get(this.mName);
        this.mWorker.getThread().setPriority(10);
        LOG.i(this.mName, "Prepare was called. Posting.");
        this.mWorker.post(new Runnable(){

            @Override
            public void run() {
                LOG.i(MediaEncoder.this.mName, "Prepare was called. Executing.");
                MediaEncoder.this.setState(1);
                MediaEncoder.this.onPrepare(controller, maxLengthUs);
                MediaEncoder.this.setState(2);
            }
        });
    }

    final void start() {
        LOG.w(this.mName, "Start was called. Posting.");
        this.mWorker.post(new Runnable(){

            @Override
            public void run() {
                if (MediaEncoder.this.mState < 2 || MediaEncoder.this.mState >= 3) {
                    LOG.e(MediaEncoder.this.mName, "Wrong state while starting. Aborting.", MediaEncoder.this.mState);
                    return;
                }
                MediaEncoder.this.setState(3);
                LOG.w(MediaEncoder.this.mName, "Start was called. Executing.");
                MediaEncoder.this.onStart();
            }
        });
    }

    final void notify(final @NonNull String event, final @Nullable Object data) {
        if (!this.mPendingEvents.containsKey(event)) {
            this.mPendingEvents.put(event, new AtomicInteger(0));
        }
        final AtomicInteger pendingEvents = this.mPendingEvents.get(event);
        pendingEvents.incrementAndGet();
        LOG.v(this.mName, "Notify was called. Posting. pendingEvents:", pendingEvents.intValue());
        this.mWorker.post(new Runnable(){

            @Override
            public void run() {
                LOG.v(MediaEncoder.this.mName, "Notify was called. Executing. pendingEvents:", pendingEvents.intValue());
                MediaEncoder.this.onEvent(event, data);
                pendingEvents.decrementAndGet();
            }
        });
    }

    final void stop() {
        if (this.mState >= 6) {
            LOG.e(this.mName, "Wrong state while stopping. Aborting.", this.mState);
            return;
        }
        this.setState(6);
        LOG.w(this.mName, "Stop was called. Posting.");
        this.mWorker.post(new Runnable(){

            @Override
            public void run() {
                LOG.w(MediaEncoder.this.mName, "Stop was called. Executing.");
                MediaEncoder.this.onStop();
            }
        });
    }

    @EncoderThread
    protected abstract void onPrepare(@NonNull MediaEncoderEngine.Controller var1, long var2);

    @EncoderThread
    protected abstract void onStart();

    @EncoderThread
    protected void onEvent(@NonNull String event, @Nullable Object data) {
    }

    @EncoderThread
    protected abstract void onStop();

    @CallSuper
    protected void onStopped() {
        LOG.w(this.mName, "is being released. Notifying controller and releasing codecs.");
        this.mController.notifyStopped(this.mTrackIndex);
        this.mMediaCodec.stop();
        this.mMediaCodec.release();
        this.mMediaCodec = null;
        this.mOutputBufferPool.clear();
        this.mOutputBufferPool = null;
        this.mBuffers = null;
        this.setState(7);
        this.mWorker.destroy();
    }

    protected boolean tryAcquireInputBuffer(@NonNull InputBuffer holder) {
        int inputBufferIndex;
        if (this.mBuffers == null) {
            this.mBuffers = new MediaCodecBuffers(this.mMediaCodec);
        }
        if ((inputBufferIndex = this.mMediaCodec.dequeueInputBuffer(0L)) < 0) {
            return false;
        }
        holder.index = inputBufferIndex;
        holder.data = this.mBuffers.getInputBuffer(inputBufferIndex);
        return true;
    }

    protected void acquireInputBuffer(@NonNull InputBuffer holder) {
        while (!this.tryAcquireInputBuffer(holder)) {
        }
    }

    protected void encodeInputBuffer(InputBuffer buffer) {
        LOG.v(this.mName, "ENCODING - Buffer:", buffer.index, "Bytes:", buffer.length, "Presentation:", buffer.timestamp);
        if (buffer.isEndOfStream) {
            this.mMediaCodec.queueInputBuffer(buffer.index, 0, 0, buffer.timestamp, 4);
        } else {
            this.mMediaCodec.queueInputBuffer(buffer.index, 0, buffer.length, buffer.timestamp, 0);
        }
    }

    @SuppressLint(value={"LogNotTimber"})
    protected final void drainOutput(boolean drainAll) {
        block11: {
            LOG.i(this.mName, "DRAINING - EOS:", drainAll);
            if (this.mMediaCodec == null) {
                LOG.e("drain() was called before prepare() or after releasing.");
                return;
            }
            if (this.mBuffers == null) {
                this.mBuffers = new MediaCodecBuffers(this.mMediaCodec);
            }
            while (true) {
                boolean isCodecConfig;
                int encoderStatus = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, 0L);
                LOG.i(this.mName, "DRAINING - Got status:", encoderStatus);
                if (encoderStatus == -1) {
                    if (drainAll) continue;
                    break block11;
                }
                if (encoderStatus == -3) {
                    this.mBuffers.onOutputBuffersChanged();
                    continue;
                }
                if (encoderStatus == -2) {
                    if (this.mController.isStarted()) {
                        throw new RuntimeException("MediaFormat changed twice.");
                    }
                    MediaFormat newFormat = this.mMediaCodec.getOutputFormat();
                    this.mTrackIndex = this.mController.notifyStarted(newFormat);
                    this.setState(4);
                    this.mOutputBufferPool = new OutputBufferPool(this.mTrackIndex);
                    continue;
                }
                if (encoderStatus < 0) {
                    LOG.e("Unexpected result from dequeueOutputBuffer: " + encoderStatus);
                    continue;
                }
                ByteBuffer encodedData = this.mBuffers.getOutputBuffer(encoderStatus);
                boolean bl = isCodecConfig = (this.mBufferInfo.flags & 2) != 0;
                if (!isCodecConfig && this.mController.isStarted() && this.mBufferInfo.size != 0) {
                    encodedData.position(this.mBufferInfo.offset);
                    encodedData.limit(this.mBufferInfo.offset + this.mBufferInfo.size);
                    if (this.mFirstTimeUs == Long.MIN_VALUE) {
                        this.mFirstTimeUs = this.mBufferInfo.presentationTimeUs;
                        LOG.w(this.mName, "DRAINING - Got the first presentation time:", this.mFirstTimeUs);
                    }
                    this.mLastTimeUs = this.mBufferInfo.presentationTimeUs;
                    this.mBufferInfo.presentationTimeUs = this.mStartTimeMillis * 1000L + this.mLastTimeUs - this.mFirstTimeUs;
                    LOG.v(this.mName, "DRAINING - About to write(). Adjusted presentation:", this.mBufferInfo.presentationTimeUs);
                    OutputBuffer buffer = (OutputBuffer)this.mOutputBufferPool.get();
                    buffer.info = this.mBufferInfo;
                    buffer.trackIndex = this.mTrackIndex;
                    buffer.data = encodedData;
                    this.onWriteOutput(this.mOutputBufferPool, buffer);
                }
                this.mMediaCodec.releaseOutputBuffer(encoderStatus, false);
                if (!drainAll && !this.mMaxLengthReached && this.mFirstTimeUs != Long.MIN_VALUE && this.mLastTimeUs - this.mFirstTimeUs > this.mMaxLengthUs) {
                    LOG.w(this.mName, "DRAINING - Reached maxLength! mLastTimeUs:", this.mLastTimeUs, "mStartTimeUs:", this.mFirstTimeUs, "mDeltaUs:", this.mLastTimeUs - this.mFirstTimeUs, "mMaxLengthUs:", this.mMaxLengthUs);
                    this.onMaxLengthReached();
                    break block11;
                }
                if ((this.mBufferInfo.flags & 4) != 0) break;
            }
            LOG.w(this.mName, "DRAINING - Got EOS. Releasing the codec.");
            this.onStopped();
        }
    }

    @CallSuper
    protected void onWriteOutput(@NonNull OutputBufferPool pool, @NonNull OutputBuffer buffer) {
        this.mController.write(pool, buffer);
    }

    protected abstract int getEncodedBitRate();

    protected long getMaxLengthUs() {
        return this.mMaxLengthUs;
    }

    protected void notifyMaxLengthReached() {
        this.onMaxLengthReached();
    }

    protected boolean hasReachedMaxLength() {
        return this.mMaxLengthReached;
    }

    private void onMaxLengthReached() {
        if (this.mMaxLengthReached) {
            LOG.w(this.mName, "onMaxLengthReached: Called twice.");
        } else {
            this.mMaxLengthReached = true;
            if (this.mState >= 5) {
                LOG.w(this.mName, "onMaxLengthReached: Reached in wrong state. Aborting.", this.mState);
            } else {
                LOG.w(this.mName, "onMaxLengthReached: Requesting a stop.");
                this.setState(5);
                this.mController.requestStop(this.mTrackIndex);
            }
        }
    }

    protected final void notifyFirstFrameMillis(long firstFrameMillis) {
        this.mStartTimeMillis = firstFrameMillis;
    }

    protected final int getPendingEvents(@NonNull String event) {
        return this.mPendingEvents.get(event).intValue();
    }
}

