package com.talpa.translate.network

import android.util.Log
import androidx.annotation.Keep
import com.jakewharton.retrofit2.adapter.kotlin.coroutines.CoroutineCallAdapterFactory
import com.talpa.TranslationController
import com.talpa.translate.base.utils.crypt
import com.talpa.translate.network.service.ApiService
import com.talpa.translate.ocr.exception.NoContentException
import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import java.util.concurrent.TimeUnit

/**
 * Hi Translator Sync
 *
 * @author CY 20-3-5
 */
@Keep
class HiTranslator private constructor() {
    companion object {

        //private const val DEBUG_BASE_URL = "http://tapi.translasion.com/"
        private const val RELEASE_BASE_URL = "https://api.translasion.com/"
        private const val CONNECT_TIME_OUT = 6000
        private const val READ_TIME_OUT = 6000
        private const val REQUEST_METHOD = "POST"
        private const val CONTENT_TYPE = "application/json"
        private const val APP_KEY = "app_key"
        private const val PREFER_TRANSLATOR = "prefer_translator_data"
        const val SERVER_SECRET = "1e98215f-929b-7cd9-9c20-4c523d4b493b"
        const val SERVER_KEY = "e292400433a4"

        @Volatile
        private var mInstance: HiTranslator? = null

        fun getInstance(): HiTranslator {
            if (mInstance == null) {
                synchronized(HiTranslator::class.java) {
                    if (mInstance == null) {
                        mInstance =
                            HiTranslator()
                    }
                }
            }
            return mInstance!!
        }
    }

    private val apiService: ApiService

    init {

        val okHttpClient = OkHttpClient.Builder()
            .connectTimeout(CONNECT_TIME_OUT.toLong(), TimeUnit.MILLISECONDS)
            .readTimeout(READ_TIME_OUT.toLong(), TimeUnit.MILLISECONDS)
            .addInterceptor {
                val newRequest = it.request().newBuilder()
                    .addHeader("content-type",
                        CONTENT_TYPE
                    )
                    .build()
                Log.d("cjslog", "new Request:$newRequest" +
                        " body:${newRequest.body?.toString()}")
                it.proceed(newRequest)
            }
            .build()

        apiService = Retrofit.Builder()
            .baseUrl(RELEASE_BASE_URL)
            .client(okHttpClient)
            .addConverterFactory(GsonConverterFactory.create())
            .addCallAdapterFactory(CoroutineCallAdapterFactory.invoke())
            .build().create(ApiService::class.java)
    }

    suspend fun postTranslate(from: String, to: String, tests: List<String>): TransResponse {
//        str = sprintf("%s&%s&%s&%s&%s", appId, to, timestamp, secret, nonce)
//        sig = md5(str)
        val serverAppKey =
            TranslationController.serverAppKey ?: throw NoContentException("app key not set")
        val serverSecret =
            TranslationController.serverAppSecret ?: throw NoContentException("app secret not set")
        val timeStamp = System.currentTimeMillis()
        val random = ((Math.random() * 9 + 1) * 1000).toInt()
        val randomKey = "${serverAppKey}&$to&$timeStamp&${serverSecret}&$random"

        val requestbody =
            TransRequest(
                app_key = serverAppKey,
                from = from,
                to = to,
                texts = tests,
                sig = crypt(randomKey),
                nonce = random.toString(),
                timestamp = timeStamp
            )

        return apiService.translate(
            requestbody
        )
    }
}