package com.talpa.translate.ocr

import android.content.Context
import com.talpa.translate.base.utils.googleVisionLanuages
import com.talpa.translate.factory.TranslatorFactory

/**
 * Create by chenjunsheng on 2020/7/29
 */
object OcrDispatcher {

    private var googleOcrEnable = true

    fun setGoogleOcrEnable(googleOcrEnable: Boolean) {
        this.googleOcrEnable = googleOcrEnable
    }

    fun dispatchOcrTranslator(context: Context, sourceLanguage: String) : Recognizer {
        return if (googleVisionLanuages.contains(sourceLanguage) && googleOcrEnable) {
            TranslatorFactory.getGoogleRecognizer(context)
        } else {
            TranslatorFactory.getFirebaseRecognizer(context)
        }
    }

}
