package com.talpa.translate.ocr

import android.graphics.Bitmap
import android.graphics.Rect
import android.util.Log

/**
 * Create by chenjunsheng on 2020/7/28
 */
class PhotoAnalyzer {

    //private var sourceMatAddr: Long = 0
    //private var sourceBitmap: Bitmap? = null
    private var sourceConfig: Bitmap.Config? = null

    /**
     * for jni call
     */
    fun getSourceConfig() : Bitmap.Config? {
        Log.d("cjslog", "from jni call")
        return sourceConfig
    }

    fun initialize(bitmap: Bitmap) {
        //sourceBitmap = bitmap
        sourceConfig = bitmap.config
        initializeNative(bitmap)
    }

    fun cleanUp() {
        cleanUpNative()
    }

    private fun generateBgBitmap(rects: Array<Rect>) : Bitmap? {
        return generateBitmapNative(rects)
    }

    fun postAnalyzeArea(rects: Array<Rect>) : Bitmap? {
        return generateBgBitmap(rects)
    }

    fun getBase64String() : String? {
        return getBase64Native()
    }

    private external fun generateBitmapNative(areas: Array<Rect>) : Bitmap?

    private external fun initializeNative(bitmap: Bitmap)

    private external fun analyzeTextColor(areas: Array<Rect>) : IntArray

    private external fun preprocessor() : Bitmap?

    private external fun getBase64Native() : String?

    private external fun cleanUpNative()
}