package com.talpa.translate.ocr

import android.content.Context
import android.graphics.Bitmap
import android.graphics.Rect
import android.util.Log
import androidx.annotation.Keep
import com.talpa.translate.ocr.text.NormalTextDrawer

/**
 * Create by chenjunsheng on 2020/7/28
 */
@Keep
class PhotoAnalyzer(context: Context) : IAnalyzer {

    companion object {
        init {
            System.loadLibrary("opencv_java4")
            System.loadLibrary("imgprocessor")
        }
    }

    private val mTextDrawer = NormalTextDrawer(context)

    override fun getTextDrawer(): TextDrawer {
        return mTextDrawer
    }

    private var mNativeAddr: Long = 0
    private var mRecycled = true

    //private var sourceMatAddr: Long = 0
    //private var sourceBitmap: Bitmap? = null
    private var sourceConfig: Bitmap.Config? = null

    /**
     * for jni call
     */
    fun getSourceConfig() : Bitmap.Config? {
        Log.d("cjslog", "from jni call")
        return sourceConfig
    }

    override fun initialize(bitmap: Bitmap) {
        //sourceBitmap = bitmap
        mNativeAddr = initializeNative(bitmap)
        if (mNativeAddr == 0L) {
            throw RuntimeException("can't initialize photo analyze object")
        }
        mRecycled = false
        sourceConfig = bitmap.config

    }

    override fun cleanUp() {
        if (!mRecycled) {
            cleanUpNative(mNativeAddr)
            mRecycled = true
        }
    }

    private fun generateBgBitmap(rects: Array<Rect>) : Bitmap? {
        if (mRecycled) {
            throw IllegalStateException("analyzer has been recycled")
        }
        return generateBitmapNative(rects)
    }

    override fun postAnalyzeArea(rects: Array<Rect>) : Bitmap? {

        return generateBgBitmap(rects)
    }

    override fun getBase64String() : String? {
        if (mRecycled) {
            throw IllegalStateException("analyzer has been recycled")
        }
        return getBase64Native()
    }

    private external fun generateBitmapNative(areas: Array<Rect>) : Bitmap?

    private external fun initializeNative(bitmap: Bitmap) : Long

    private external fun analyzeTextColor(areas: Array<Rect>) : IntArray

    private external fun preprocessor() : Bitmap?

    private external fun getBase64Native() : String?

    private external fun cleanUpNative(addr: Long)
}