package com.talpa.translate.ocr

import android.content.Context
import android.graphics.Bitmap
import android.graphics.Rect
import android.util.Log
import androidx.annotation.Keep
import com.talpa.translate.ocr.text.NormalTextDrawer

/**
 * Create by chenjunsheng on 2020/7/28
 */
class PhotoAnalyzer(context: Context) : IAnalyzer {

    companion object {
        init {
            System.loadLibrary("opencv_java4")
            System.loadLibrary("imgprocessor")
        }

        fun getBase64String(bitmap: Bitmap) : String? {
            return getBase64Native(bitmap)
        }

        @JvmStatic
        external fun preprocessor(bitmap: Bitmap) : Bitmap?

        @JvmStatic
        private external fun getBase64Native(bitmap: Bitmap) : String?
    }

    private val mTextDrawer = NormalTextDrawer(context)

    override fun getTextDrawer(): TextDrawer {
        return mTextDrawer
    }

    private var mNativeAddr: Long = 0
    private var mRecycled = true

    private var sourceConfig: Bitmap.Config? = null

    /**
     * for jni call
     * 这个函数名称不能混淆
     */
    @Keep
    fun getSourceConfig() : Bitmap.Config? {
        Log.d("cjslog", "from jni call")
        return sourceConfig
    }

    override fun initialize(bitmap: Bitmap) {
        //sourceBitmap = bitmap
        mNativeAddr = initializeNative(bitmap)
        if (mNativeAddr == 0L) {
            throw RuntimeException("can't initialize photo analyze object")
        }
        mRecycled = false
        sourceConfig = bitmap.config

    }

    override fun release() {
        if (!mRecycled) {
            nReleaseNative(mNativeAddr)
            mRecycled = true
        }
    }

    private fun generateBgBitmap(rects: Array<Rect>) : Bitmap? {
        if (mRecycled) {
            throw IllegalStateException("analyzer has been recycled")
        }
        return generateBitmapNative(rects)
    }

    override fun postAnalyzeArea(rects: Array<Rect>) : Bitmap? {

        return generateBgBitmap(rects)
    }

    private external fun generateBitmapNative(areas: Array<Rect>) : Bitmap?

    private external fun initializeNative(bitmap: Bitmap) : Long

    //private external fun analyzeTextColor(areas: Array<Rect>) : IntArray

    private external fun nReleaseNative(addr: Long)

    private external fun convert64ToBitmap(base64: String) : Bitmap
}