package com.talpa.translate.render

import android.content.Context
import android.graphics.Bitmap
import android.graphics.Rect
import android.util.Log
import com.talpa.translate.base.utils.BitmapUtils
import com.talpa.translate.camera.view.controls.Facing
import com.talpa.translate.ocr.IAnalyzer
import com.talpa.translate.ocr.Recognizer
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.async
import kotlinx.coroutines.withContext

/**
 * Create by chenjunsheng on 2020/7/14
 */
class TranslatorRender(val context: Context, private val photoAnalyzer: IAnalyzer) : Render {

    private var mOriginBitmap: Bitmap? = null

    /*override fun initialize(originalBitmap: Bitmap) {
        //release() //first release avoid memory leak
        mOriginBitmap = originalBitmap
        photoAnalyzer.initialize(originalBitmap)
    }*/

    override fun getOcrBitmap(): Bitmap {
        return checkNotNull(mOriginBitmap)
    }

    /*override fun release() {
        mOriginBitmap = null
        photoAnalyzer.cleanUp()
    }*/

    override suspend fun renderOverlay(bitmap: Bitmap, translator: Recognizer, transResult: List<String>): Bitmap? {
        return withContext(Dispatchers.Main) {
            val ocrResult = translator.getHistory() ?: return@withContext null
            val task = async(Dispatchers.IO) {
                photoAnalyzer.initialize(bitmap)
                val rects = arrayListOf<Rect>()
                ocrResult.blocks.forEach {
                    rects.add(it.rect)
                }
                val background = photoAnalyzer.postAnalyzeArea(rects.toTypedArray())
                photoAnalyzer.release()
                Log.d("cjslog", "bitmap recycle:${bitmap.isRecycled}")
                background
            }

            /*val originBitmap = handleVisionTextToBitmap(
                task.await() ?: return@withContext null,
                ocrResult,
                translator.getFrameMetadata() ?: return@withContext null,
                transResult
            )*/

            val originBitmap = photoAnalyzer.getTextDrawer().draw(
                task.await() ?: return@withContext null,
                translator.getFrameMetadata() ?: return@withContext null,
                ocrResult,
                transResult
            )

            val overlayBitmap = BitmapUtils.reRotateBitmap(
                originBitmap,
                translator.getFrameMetadata()?.rotation ?: 0,
                Facing.BACK
            )
            originBitmap.recycle()
            overlayBitmap
        }
    }

}