package com.talpa.translate.ocr.result

import android.content.Intent
import android.os.Bundle
import android.view.View
import androidx.fragment.app.Fragment
import androidx.fragment.app.activityViewModels
import com.photo.translation.R
import com.photo.translation.databinding.ContrastSentenceFragmentBinding
import com.talpa.translate.base.utils.PT_contrast_edit
import com.talpa.translate.base.utils.logEvent
import com.talpa.translate.camera.COMPLETE_RESULT

/**
 * Create by chenjunsheng on 2020/10/15
 */
class ContrastSentenceFragment : Fragment(R.layout.contrast_sentence_fragment),
    View.OnClickListener {

    private val model: ContrastViewModel by activityViewModels()
    private lateinit var binding: ContrastSentenceFragmentBinding
    private var mAdapter: ContrastAdapter? = null

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        binding = ContrastSentenceFragmentBinding.bind(view)

        model.completeModel.observe(viewLifecycleOwner, {
            mAdapter = ContrastAdapter(it)
            binding.contrast.adapter = mAdapter
        })

        binding.toolbar.setNavigationOnClickListener {
            /*if (!findNavController().navigateUp()) {
            }*/
            activity?.finish()
        }
        binding.menu.setOnClickListener(this)
    }

    override fun onClick(v: View) {
        when (v.id) {
            R.id.menu -> {
                val bundle = Bundle()
                bundle.putBinder(COMPLETE_RESULT, CompleteTransfer(model.completeModel.value))
                startActivity(Intent(requireContext(), ContrastEditActivity::class.java)
                    .also { it.putExtras(bundle) })
                //findNavController().navigate(R.id.action_contrastSentenceFragment_to_contrastEditFragment)
                logEvent(PT_contrast_edit)
            }
        }

    }
}