package com.talpa.translate.ocr

import android.graphics.Bitmap
import com.talpa.translate.base.common.FrameMetadata
import com.talpa.translate.ocr.datasource.RenderSource
import com.talpa.translate.ocr.result.OcrResult

/**
 * Create by chenjunsheng on 2020/8/3
 */
interface TextDrawer {

    /**
     * 把翻译后的结果渲染在原图像上
     * @param background 原图像，用于做文字提取
     * @param frameMetadata 角度参数，用于调整角度
     * @param ocrResult ocr 结果，用于定位文字
     * @param transResult 翻译后的结果，用于绘制
     */
    fun draw(
        renderSource: RenderSource,
        frameMetadata: FrameMetadata,
        ocrResult: OcrResult,
        transResult: List<String?>
    ) : Bitmap?
}