package com.talpa.base.trace

import android.content.Intent
import android.util.Log
import androidx.annotation.Keep
import androidx.annotation.RestrictTo
import androidx.localbroadcastmanager.content.LocalBroadcastManager
import com.talpa.base.BaseApp
import com.talpa.base.utils.ACTION_DATA_ANALYSIS
import com.talpa.base.utils.EXTRA_EVENT_ID
import com.talpa.base.utils.EXTRA_EVENT_PARAMS

private const val TAG = "hitranslation_event"

/**
 * Create by chenjunsheng on 2020/5/14
 */
@Keep
@RestrictTo(RestrictTo.Scope.LIBRARY)
class HiTranslatTrace : ITraceEvent {

    private val dataMap = HashMap<String, String>()

    override fun logEvent(eventName: String, key: String?, value: String?) {
        Log.d(
            TAG,
            "event:${eventName} key:${key} value:${value}"
        )
        dataMap.clear()
        LocalBroadcastManager.getInstance(BaseApp.appContext)
            .sendBroadcast(
                Intent(ACTION_DATA_ANALYSIS)
                .also {
                    it.putExtra(EXTRA_EVENT_ID, eventName)
                    if (key != null && value != null) {
                        it.putExtra(EXTRA_EVENT_PARAMS, dataMap.apply { put(key, value) })
                    }
                })
    }
}