package com.talpa.base.trace

import com.photo.translation.BuildConfig
import java.lang.Exception

/**
 * Create by chenjunsheng on 2020/5/13
 */
object TraceFactory {

    fun createTraceSession() : ITraceEvent? {
        var event: ITraceEvent? = null
        when (BuildConfig.FLAVOR) {
            "sdk" -> {
                try {
                    val traceClass = Class.forName("com.talpa.base.trace.SDKEventTrace")
                    event = traceClass.newInstance() as? ITraceEvent

                } catch (e: Exception) {
                    event = null
                }
            }
            "hitranslate" -> {
                try {
                    val traceClass = Class.forName("com.talpa.base.trace.HiTranslatTrace")
                    event = traceClass.newInstance() as? ITraceEvent
                } catch (e: Exception) {
                    event = null
                }
            }
        }
        return event
    }
}