package com.talpa.camera.opengl.surface


import com.talpa.camera.opengl.core.EglCore


/**
 * A pbuffer EGL surface.
 */
@Suppress("unused")
open class EglOffscreenSurface(
    eglCore: EglCore,
    width: Int,
    height: Int
) : EglSurface(
        eglCore,
        eglCore.createOffscreenSurface(width, height)
) {

    init {
        // Cache this values
        setWidth(width)
        setHeight(height)
    }
}
