package com.talpa.camera.translate.photo

import android.content.Context
import android.view.ViewGroup
import androidx.lifecycle.LifecycleOwner
import com.talpa.base.common.FrameMetadata
import com.talpa.camera.cameraview.CameraView

/**
 * Create by chenjunsheng on 2020/5/7
 */
interface ICameraSource {

    fun initialize(context: Context, camera: CameraView, lifecycleOwner: LifecycleOwner)

    fun setStatusCallback(status: Status)

    fun open()

    fun pause()

    fun release()

    fun takePicture()

    fun torch(switch: Boolean)

    interface Status {
        fun cameraInitializeFail(exception: Exception)

        fun onPicturetaked(data: ByteArray, metadata: FrameMetadata)

        fun onPicturetakeFail(exception: Exception)

        fun onStatusChange(state: Int)
    }

    companion object {
        const val TORCH_ON = 0
        const val TORCH_OFF = 1
    }
}