package com.talpa.camera.translate.utils

import android.content.Context
import android.graphics.*
import android.net.ConnectivityManager
import android.text.StaticLayout
import android.text.TextPaint
import android.util.Log
import com.talpa.base.BaseApp
import com.talpa.camera.edmodo.cropper.cropwindow.edge.Edge
import com.tencent.mmkv.MMKV

/**
 * Create by chenjunsheng on 2020/4/27
 */

private const val RATIO_4_3_VALUE = 4.0 / 3.0
private const val RATIO_16_9_VALUE = 16.0 / 9.0

const val PREFER_KEY_SOURCE_LANG = "key_source_lang"
const val PREFER_NAME = "prefer_camera"

const val MAX_TEXT_SIZE_PX = 160
const val MIN_TEXT_SIZE_PX = 12

/**
 * Release origin image by translation bitmap
 */
fun replaceImage(
    completedBitmap: Bitmap,
    translationBitmap: Bitmap,
    mask: Int = Color.TRANSPARENT
): Bitmap {

    //val completedBitmap = mCropImageView.drawable.toBitmap()

    val newBitmap = Bitmap.createBitmap(
        completedBitmap.width,
        completedBitmap.height,
        completedBitmap.config
    )
    val canvas = Canvas(newBitmap)
    canvas.drawBitmap(completedBitmap, 0f, 0f, null)
    canvas.drawColor(mask)

    canvas.drawBitmap(translationBitmap, Edge.LEFT.coordinate, Edge.TOP.coordinate, Paint())

    canvas.save()
    canvas.restore()

    return newBitmap
}

/**
 *  [androidx.camera.core.ImageAnalysisConfig] requires enum value of
 *  [androidx.camera.core.AspectRatio]. Currently it has values of 4:3 & 16:9.
 *
 *  Detecting the most suitable ratio for dimensions provided in @params by counting absolute
 *  of preview ratio to one of the provided values.
 *
 *  @param width - preview width
 *  @param height - preview height
 *  @return suitable aspect ratio
 */
/*fun aspectRatio(width: Int, height: Int): Int {
    val previewRatio = max(width, height).toDouble() / min(width, height)
    if (abs(previewRatio - RATIO_4_3_VALUE) <= abs(previewRatio - RATIO_16_9_VALUE)) {
        return AspectRatio.RATIO_4_3
    }
    return AspectRatio.RATIO_16_9
}*/

/**
 * Save Language Tag
 */
fun saveLanguage(
    preferKey: String = PREFER_KEY_SOURCE_LANG,
    value: String
) {
    //val prefer = context.getSharedPreferences(PREFER_NAME, Context.MODE_PRIVATE)
    //prefer.edit().putString(preferKey, value).apply()
    val mmkv = MMKV.defaultMMKV()
    mmkv.encode(preferKey, value)
}

fun Context.isNetworkConnected(): Boolean {
    val connectivityManager =
        getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager

    val networkInfo = connectivityManager.activeNetworkInfo
    return networkInfo?.isAvailable == true && networkInfo.isConnected
}

fun adjustTextSizePx(maxSingleLine: String, area: RectF) : Float {

    val textPaintClone = TextPaint(Paint.ANTI_ALIAS_FLAG)
        .also { it.density = BaseApp.appContext.resources.displayMetrics.density }
    var trySize: Float = MAX_TEXT_SIZE_PX.toFloat()
    textPaintClone.textSize = trySize

    var fm = textPaintClone.getFontMetricsInt()
    var top = fm.top
    var bottom = fm.bottom
    //所占高度
    var height = Math.abs(bottom - top)

    var lineCount = 1
    //var trySingleLine = maxSingleLine

    Log.d("cjslog", "with:${area.width()} + ${area.height()} ${maxSingleLine}")
    while ((textPaintClone.measureText(maxSingleLine, 0, maxSingleLine.length / lineCount) > area.width()
                || lineCount * height > area.height()) && trySize > MIN_TEXT_SIZE_PX) {
        trySize--
        textPaintClone.textSize = trySize

        val staticLayout = StaticLayout.Builder
            .obtain(maxSingleLine,
                0,
            maxSingleLine.length,
            textPaintClone,
            area.width().toInt()).build()
        lineCount = staticLayout.lineCount
        //lineCount ++

        //val index = maxSingleLine.length / lineCount
        //trySingleLine = maxSingleLine.substring(0, index)

        fm = textPaintClone.getFontMetricsInt()
        top = fm.top
        bottom = fm.bottom
        height = Math.abs(bottom - top)
    }
    //适配高度
    do {

        lineCount++
        while (lineCount * height < area.height()
            && textPaintClone.measureText(maxSingleLine, 0, maxSingleLine.length / lineCount) < area.width()) {
            trySize ++
            textPaintClone.textSize = trySize
            fm = textPaintClone.getFontMetricsInt()
            top = fm.top
            bottom = fm.bottom
            height = Math.abs(bottom - top)
        }
    } while (lineCount * height < area.height())

    return trySize
    //setTextSize(TypedValue.COMPLEX_UNIT_PX, trySize)
}
