package com.talpa.translation.engine

import android.content.Context
import android.util.Log
import com.talpa.translation.controller.TranslateStateMachineImpl
import com.talpa.translation.controller.TranslationStateMachine
import com.talpa.translation.handler.TranslationHandler
import com.talpa.translation.session.TranslationSession

/**
 * Create by chenjunsheng on 2020/4/23
 * 翻译管理引擎，负责推动翻译流程
 */
object TranslationStateEngine {

    private lateinit var androidContext: Context
    private val handlerMap = HashMap<String, TranslationHandler>()
    val stateMachine: TranslationStateMachine

    init {
        stateMachine =
            TranslateStateMachineImpl()
    }

    fun initEngine(androidContext: Context) {
        TranslationStateEngine.androidContext = androidContext
    }

    fun getAndroidContext() =
        androidContext

    /**
     * 负责推动整个翻译流程
     * @param translationSession 翻译会话
     * @param event 具体事件
     */
    fun post(translationSession: TranslationSession) {
        val h =
            getHandler(
                translationSession
            )
        h.handle(translationSession)
    }

    fun setHandler(translationSession: TranslationSession, translationHandler: TranslationHandler) {
        handlerMap["${translationSession.getType().name}:${translationSession.getState().name}"] =
            translationHandler
        //Log.d("cjslog", "key2# ${translationSession.getType().name}:${translationSession.getState().name}:${translationSession.getEvent().name}")
    }

    private fun getHandler(translationSession: TranslationSession) : TranslationHandler {
        val key = "${translationSession.getType().name}:${translationSession.getState().name}"
        //Log.d("cjslog", "key# ${key}")
        return handlerMap[key] ?: throw IllegalStateException("error translateSession")
    }
}