/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.base;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.BounceInterpolator;
import com.flurry.android.FlurryConfig;
import com.photo.translation.R;
import com.talpa.TranslationController;
import com.talpa.base.BaseApp;
import com.talpa.base.screenshot.ScreenShotListenManager;
import com.talpa.base.trace.ITraceEvent;
import com.talpa.base.trace.TraceFactory;
import com.talpa.base.utils.StaticesEventKt;
import com.talpa.base.view.floatview.FloatWindow;
import com.talpa.base.view.floatview.IFloatWindow;
import com.talpa.base.view.floatview.PermissionListener;
import com.talpa.base.view.floatview.ViewStateListener;
import com.tencent.mmkv.MMKV;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;
import io.reactivex.subjects.PublishSubject;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010 \u001a\u0004\u0018\u00010\u001fJ\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0006H\u0002J\b\u0010&\u001a\u00020\"H\u0002J\u000e\u0010'\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/talpa/base/BaseApp;", "", "()V", "DEFAULT_KEY", "", "appContext", "Landroid/content/Context;", "getAppContext", "()Landroid/content/Context;", "setAppContext", "(Landroid/content/Context;)V", "floatWindow", "Lcom/talpa/base/view/floatview/IFloatWindow;", "getFloatWindow", "()Lcom/talpa/base/view/floatview/IFloatWindow;", "setFloatWindow", "(Lcom/talpa/base/view/floatview/IFloatWindow;)V", "mPermissionListener", "Lcom/talpa/base/view/floatview/PermissionListener;", "getMPermissionListener", "()Lcom/talpa/base/view/floatview/PermissionListener;", "mViewStateListener", "Lcom/talpa/base/view/floatview/ViewStateListener;", "getMViewStateListener", "()Lcom/talpa/base/view/floatview/ViewStateListener;", "serverKey", "getServerKey", "()Ljava/lang/String;", "setServerKey", "(Ljava/lang/String;)V", "traceEvent", "Lcom/talpa/base/trace/ITraceEvent;", "getTraceEvent", "initBackgourndKey", "", "initEventSdk", "initFloatingView", "context", "initMMkv", "initialize", "translation_sdkRelease"})
public final class BaseApp {
    @Nullable
    private static IFloatWindow floatWindow;
    @NotNull
    public static Context appContext;
    private static ITraceEvent traceEvent;
    @Nullable
    private static String serverKey;
    private static final String DEFAULT_KEY = "123transsion";
    @NotNull
    private static final PermissionListener mPermissionListener;
    @NotNull
    private static final ViewStateListener mViewStateListener;
    public static final BaseApp INSTANCE;

    @Nullable
    public final IFloatWindow getFloatWindow() {
        return floatWindow;
    }

    public final void setFloatWindow(@Nullable IFloatWindow iFloatWindow) {
        floatWindow = iFloatWindow;
    }

    @NotNull
    public final Context getAppContext() {
        Context context = appContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
        }
        return context;
    }

    public final void setAppContext(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"<set-?>");
        appContext = context;
    }

    @Nullable
    public final String getServerKey() {
        return serverKey;
    }

    public final void setServerKey(@Nullable String string2) {
        serverKey = string2;
    }

    public final void initialize(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        appContext = context;
        this.initFloatingView(context);
        this.initEventSdk();
        this.initMMkv();
    }

    private final void initMMkv() {
        Context context = appContext;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"appContext");
        }
        MMKV.initialize((Context)context);
    }

    private final void initEventSdk() {
        traceEvent = TraceFactory.INSTANCE.createTraceSession();
    }

    public final void initBackgourndKey() {
        try {
            FlurryConfig flurryConfig = FlurryConfig.getInstance();
            serverKey = flurryConfig.getString("trans_server_key", DEFAULT_KEY);
        }
        catch (Exception e) {
            serverKey = DEFAULT_KEY;
        }
    }

    @Nullable
    public final ITraceEvent getTraceEvent() {
        return traceEvent;
    }

    private final void initFloatingView(Context context) {
        ScreenShotListenManager screenShotManager = ScreenShotListenManager.getInstance(context);
        screenShotManager.setListener(new ScreenShotListenManager.OnScreenShotListener(context){
            final /* synthetic */ Context $context;

            public final void onShot(String imgPath, long relativePath) {
                block2: {
                    if (BaseApp.INSTANCE.getFloatWindow() == null) {
                        View button = LayoutInflater.from((Context)this.$context).inflate(R.layout.layout_tap_overlay_view, null);
                        BaseApp.INSTANCE.setFloatWindow(FloatWindow.with(this.$context).setView(button).setWidth(0, 0.2f).setHeight(0, 0.2f).setX(0, 0.8f).setY(1, 0.3f).setMoveType(3, 10, 10).setMoveStyle(500L, (TimeInterpolator)new BounceInterpolator()).setViewStateListener(BaseApp.INSTANCE.getMViewStateListener()).setPermissionListener(BaseApp.INSTANCE.getMPermissionListener()).setDesktopShow(true).build());
                    }
                    IFloatWindow iFloatWindow = BaseApp.INSTANCE.getFloatWindow();
                    if (iFloatWindow != null) {
                        iFloatWindow.setOnclickListener(new View.OnClickListener(this, imgPath, relativePath){
                            final /* synthetic */ initFloatingView.1 this$0;
                            final /* synthetic */ String $imgPath;
                            final /* synthetic */ long $relativePath;

                            public final void onClick(View it) {
                                Context context = this.this$0.$context;
                                String string2 = this.$imgPath;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"imgPath");
                                TranslationController.startTranslateFromUri(context, string2, this.$relativePath);
                                IFloatWindow iFloatWindow = BaseApp.INSTANCE.getFloatWindow();
                                if (iFloatWindow != null) {
                                    iFloatWindow.hide();
                                }
                                StaticesEventKt.logEvent$default("PT_screen_shot_click", null, null, 6, null);
                            }
                            {
                                this.this$0 = var1_1;
                                this.$imgPath = string2;
                                this.$relativePath = l;
                            }
                        });
                    }
                    Log.d((String)"cjslog", (String)"show");
                    IFloatWindow iFloatWindow2 = BaseApp.INSTANCE.getFloatWindow();
                    if (iFloatWindow2 == null) break block2;
                    iFloatWindow2.show();
                }
            }
            {
                this.$context = context;
            }
        });
    }

    @NotNull
    public final PermissionListener getMPermissionListener() {
        return mPermissionListener;
    }

    @NotNull
    public final ViewStateListener getMViewStateListener() {
        return mViewStateListener;
    }

    private BaseApp() {
    }

    static {
        BaseApp baseApp;
        INSTANCE = baseApp = new BaseApp();
        DEFAULT_KEY = DEFAULT_KEY;
        mPermissionListener = new PermissionListener(){

            public void onSuccess() {
                Log.d((String)"cjslog", (String)"on success");
            }

            public void onFail() {
                Log.d((String)"cjslog", (String)"on fail");
            }
        };
        mViewStateListener = new ViewStateListener(baseApp){
            @NotNull
            private final PublishSubject<Boolean> subject;
            final /* synthetic */ BaseApp this$0;

            @NotNull
            public final PublishSubject<Boolean> getSubject() {
                return this.subject;
            }

            public void onBackToDesktop() {
                Log.d((String)"cjslog", (String)"onBackToDesktop");
            }

            public void onMoveAnimStart() {
                Log.d((String)"cjslog", (String)"onMoveAnimStart");
            }

            public void onMoveAnimEnd() {
                Log.d((String)"cjslog", (String)"onMoveAnimEnd");
                this.subject.onNext((Object)true);
            }

            public void onPositionUpdate(int x, int y) {
                this.subject.onNext((Object)true);
            }

            public void onDismiss() {
                Log.d((String)"cjslog", (String)"onDismiss");
            }

            public void onShow() {
                Log.d((String)"cjslog", (String)"onShow");
                this.subject.onNext((Object)true);
            }

            public void onHide() {
                Log.d((String)"cjslog", (String)"onHide");
            }
            {
                this.this$0 = $outer;
                PublishSubject publishSubject = PublishSubject.create();
                Intrinsics.checkExpressionValueIsNotNull((Object)publishSubject, (String)"PublishSubject.create<Boolean>()");
                this.subject = publishSubject;
                this.subject.debounce(5L, TimeUnit.SECONDS, AndroidSchedulers.mainThread()).subscribe((Consumer)mViewStateListener.1.INSTANCE);
            }
        };
    }
}

