/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.base.common;

import com.talpa.camera.cameraview.controls.Facing;
import com.talpa.camera.cameraview.controls.PictureFormat;

public class FrameMetadata {
    private final int width;
    private final int height;
    private final int rotation;
    private final Facing cameraFacing;
    private final PictureFormat format;

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRotation() {
        return this.rotation / 90;
    }

    public Facing getCameraFacing() {
        return this.cameraFacing;
    }

    public PictureFormat getFormat() {
        return this.format;
    }

    private FrameMetadata(int width, int height, int rotation, Facing facing, PictureFormat format) {
        this.width = width;
        this.height = height;
        this.rotation = rotation;
        this.cameraFacing = facing;
        this.format = format;
    }

    public static class Builder {
        private int width;
        private int height;
        private int rotation;
        private Facing cameraFacing;
        private PictureFormat format;

        public Builder setWidth(int width) {
            this.width = width;
            return this;
        }

        public Builder setHeight(int height) {
            this.height = height;
            return this;
        }

        public Builder setRotation(int rotation) {
            this.rotation = rotation;
            return this;
        }

        public Builder setCameraFacing(Facing facing) {
            this.cameraFacing = facing;
            return this;
        }

        public Builder setPictureFormat(PictureFormat format) {
            this.format = format;
            return this;
        }

        public FrameMetadata build() {
            return new FrameMetadata(this.width, this.height, this.rotation, this.cameraFacing, this.format);
        }
    }
}

