/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.base.screenshot;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class ScreenShotListenManager {
    private static final String TAG = "ScreenShotListenManager";
    private static final String[] MEDIA_PROJECTIONS_API_16 = new String[]{"_id", "_data", "datetaken", "width", "height"};
    private final Executor mExecutor = Executors.newSingleThreadExecutor();
    private static final String[] KEYWORDS = new String[]{"screenshot", "screen_shot", "screen-shot", "screen shot", "screencapture", "screen_capture", "screen-capture", "screen capture", "screencap", "screen_cap", "screen-cap", "screen cap", "\u622a\u5c4f", "screenshots", "screencaps"};
    private static Point sScreenRealSize;
    private final List<String> sHasCallbackPaths = new ArrayList<String>();
    private Context mContext;
    private OnScreenShotListener mListener;
    private long mStartListenTime;
    private MediaContentObserver mInternalObserver;
    private MediaContentObserver mExternalObserver;
    private final Handler mUiHandler = new Handler(Looper.getMainLooper());
    private static ScreenShotListenManager mInstance;

    private ScreenShotListenManager(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("The context must not be null.");
        }
        this.mContext = context;
        if (sScreenRealSize == null) {
            sScreenRealSize = this.getRealScreenSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScreenShotListenManager getInstance(Context context) {
        ScreenShotListenManager.assertInMainThread();
        if (mInstance != null) return mInstance;
        Class<ScreenShotListenManager> clazz = ScreenShotListenManager.class;
        synchronized (ScreenShotListenManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ScreenShotListenManager(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mInstance;
        }
    }

    public void startListen() {
        ScreenShotListenManager.assertInMainThread();
        this.mStartListenTime = System.currentTimeMillis();
        this.mInternalObserver = new MediaContentObserver(MediaStore.Images.Media.INTERNAL_CONTENT_URI, this.mUiHandler);
        this.mExternalObserver = new MediaContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.mUiHandler);
        this.mContext.getContentResolver().registerContentObserver(MediaStore.Images.Media.INTERNAL_CONTENT_URI, false, (ContentObserver)this.mInternalObserver);
        this.mContext.getContentResolver().registerContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, false, (ContentObserver)this.mExternalObserver);
    }

    public void stopListen() {
        ScreenShotListenManager.assertInMainThread();
        if (this.mInternalObserver != null) {
            try {
                this.mContext.getContentResolver().unregisterContentObserver((ContentObserver)this.mInternalObserver);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mInternalObserver = null;
        }
        if (this.mExternalObserver != null) {
            try {
                this.mContext.getContentResolver().unregisterContentObserver((ContentObserver)this.mExternalObserver);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mExternalObserver = null;
        }
        this.mStartListenTime = 0L;
    }

    private void handleMediaRowData(String data, long dateTaken, int width, int height, long id2) {
        if (this.checkScreenShot(data, dateTaken, width, height)) {
            if (this.hasExistHist(data)) {
                Log.d((String)TAG, (String)("handleMediaRowData: has exist " + data));
                return;
            }
            if (this.mListener != null) {
                Log.d((String)TAG, (String)("handleMediaRowData: not exist and show dialog " + data));
                this.mListener.onShot(data, id2);
            }
        }
    }

    private boolean checkScreenShot(String data, long dateTaken, int width, int height) {
        if (dateTaken < this.mStartListenTime || System.currentTimeMillis() - dateTaken > 30000L) {
            return false;
        }
        if (sScreenRealSize != null) {
            boolean isHorizontalHeight;
            boolean isVerticalWidth = width <= ScreenShotListenManager.sScreenRealSize.x && height <= ScreenShotListenManager.sScreenRealSize.y;
            boolean bl = isHorizontalHeight = height <= ScreenShotListenManager.sScreenRealSize.x && width <= ScreenShotListenManager.sScreenRealSize.y;
            if (!isVerticalWidth && !isHorizontalHeight) {
                return false;
            }
        }
        if (TextUtils.isEmpty((CharSequence)data)) {
            return false;
        }
        data = data.toLowerCase();
        for (String keyWork : KEYWORDS) {
            if (!data.contains(keyWork)) continue;
            return true;
        }
        return false;
    }

    private boolean hasExistHist(String imagePath) {
        if (this.sHasCallbackPaths.contains(imagePath)) {
            Log.e((String)TAG, (String)("has exist " + imagePath));
            return true;
        }
        if (this.sHasCallbackPaths.size() >= 20) {
            for (int i = 0; i < 5; ++i) {
                this.sHasCallbackPaths.remove(0);
            }
        }
        this.sHasCallbackPaths.add(imagePath);
        return false;
    }

    private Point getRealScreenSize() {
        Point screenSize = new Point();
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        Display defaultDisplay = windowManager.getDefaultDisplay();
        defaultDisplay.getRealSize(screenSize);
        return screenSize;
    }

    public void setListener(OnScreenShotListener listener) {
        this.mListener = listener;
    }

    private static void assertInMainThread() {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            StackTraceElement[] elements = Thread.currentThread().getStackTrace();
            String methodMsg = null;
            if (elements != null && elements.length >= 4) {
                methodMsg = elements[3].toString();
            }
            throw new IllegalStateException("Call the method must be in main thread: " + methodMsg);
        }
    }

    private void handleMediaContentChange(Uri contentUri) {
        this.mExecutor.execute(() -> {
            Cursor cursor = null;
            try {
                int height;
                int width;
                cursor = this.mContext.getContentResolver().query(contentUri, MEDIA_PROJECTIONS_API_16, null, null, "date_added desc limit 1");
                if (cursor == null) {
                    return;
                }
                if (!cursor.moveToFirst()) {
                    return;
                }
                int dataIndex = cursor.getColumnIndex("_data");
                int dateTakenIndex = cursor.getColumnIndex("datetaken");
                int widthIndex = cursor.getColumnIndex("width");
                int heightIndex = cursor.getColumnIndex("height");
                int idIndex = cursor.getColumnIndex("_id");
                final long id2 = cursor.getLong(idIndex);
                final String data = cursor.getString(dataIndex);
                final long dateTaken = cursor.getLong(dateTakenIndex);
                if (widthIndex >= 0 && heightIndex >= 0) {
                    width = cursor.getInt(widthIndex);
                    height = cursor.getInt(heightIndex);
                } else {
                    width = 0;
                    height = 0;
                }
                Log.e((String)TAG, (String)("data : " + data + " dateTaken:" + dateTaken + " diff now: " + (System.currentTimeMillis() - dateTaken)));
                this.mUiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        ScreenShotListenManager.this.handleMediaRowData(data, dateTaken, width, height, id2);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (cursor != null && !cursor.isClosed()) {
                    cursor.close();
                }
            }
        });
    }

    private class MediaContentObserver
    extends ContentObserver {
        private Uri mContentUri;

        public MediaContentObserver(Uri contentUri, Handler handler) {
            super(handler);
            this.mContentUri = contentUri;
        }

        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            ScreenShotListenManager.this.handleMediaContentChange(this.mContentUri);
        }
    }

    public static interface OnScreenShotListener {
        public void onShot(String var1, long var2);
    }
}

