/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.base.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.Log;
import androidx.annotation.Nullable;
import com.talpa.base.common.FrameMetadata;
import com.talpa.camera.cameraview.controls.Facing;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class BitmapUtils {
    @Nullable
    public static Bitmap getBitmap(byte[] data, FrameMetadata metadata) {
        try {
            YuvImage image = new YuvImage(data, 17, metadata.getWidth(), metadata.getHeight(), null);
            if (image != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                image.compressToJpeg(new Rect(0, 0, metadata.getWidth(), metadata.getHeight()), 80, (OutputStream)stream);
                Bitmap bmp = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
                stream.close();
                return BitmapUtils.rotateBitmap(bmp, metadata.getRotation(), metadata.getCameraFacing());
            }
        }
        catch (Exception e) {
            Log.e((String)"VisionProcessorBase", (String)("Error: " + e.getMessage()));
        }
        return null;
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, int rotation, Facing facing) {
        Matrix matrix = new Matrix();
        int rotationDegree = 0;
        switch (rotation) {
            case 1: {
                rotationDegree = 90;
                break;
            }
            case 2: {
                rotationDegree = 180;
                break;
            }
            case 3: {
                rotationDegree = 270;
                break;
            }
        }
        matrix.postRotate((float)rotationDegree);
        if (facing == Facing.BACK) {
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        matrix.postScale(-1.0f, 1.0f);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static Bitmap reRotateBitmap(Bitmap bitmap, int rotation, Facing facing) {
        Matrix matrix = new Matrix();
        int rotationDegree = 0;
        switch (rotation) {
            case 1: {
                rotationDegree = -90;
                break;
            }
            case 2: {
                rotationDegree = -180;
                break;
            }
            case 3: {
                rotationDegree = -270;
                break;
            }
        }
        matrix.postRotate((float)rotationDegree);
        if (facing == Facing.BACK) {
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        matrix.postScale(-1.0f, 1.0f);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
    }
}

