/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.base.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Environment;
import android.os.StatFs;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b\u001a\u0006\u0010\t\u001a\u00020\n\u001a\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0003\u00a8\u0006\u000f"}, d2={"createPhotoFile", "Ljava/io/File;", "context", "Landroid/content/Context;", "drawTextToBitmap", "Landroid/graphics/Bitmap;", "bitmap", "text", "", "getFreeSpace", "", "isSDCardEnable", "", "navigationBarHeight", "", "translation_sdkRelease"})
public final class UtilsKt {
    public static final boolean isSDCardEnable() {
        return Intrinsics.areEqual((Object)"mounted", (Object)Environment.getExternalStorageState());
    }

    public static final long getFreeSpace() {
        if (!UtilsKt.isSDCardEnable()) {
            return -1L;
        }
        StatFs stat = new StatFs(Environment.getExternalStorageDirectory().getPath());
        long blockSize = stat.getBlockSizeLong();
        long availableBlocks = stat.getAvailableBlocksLong();
        long size = availableBlocks * blockSize / 1024L;
        return size;
    }

    @NotNull
    public static final File createPhotoFile(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object[] objectArray = context.getExternalMediaDirs();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"context.externalMediaDirs");
        File file = (File)ArraysKt.firstOrNull((Object[])objectArray);
        if (file == null) {
            File file2 = context.getFilesDir();
            file = file2;
            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"context.filesDir");
        }
        File baseDir = file;
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        String pattern = "yyyy-MM-dd-HH-mm-ss";
        String extension = ".jpg";
        String dateFormat = new SimpleDateFormat(pattern, Locale.US).format(System.currentTimeMillis());
        String fileName = dateFormat + extension;
        return new File(baseDir, fileName);
    }

    public static final int navigationBarHeight(@NotNull Context $this$navigationBarHeight) {
        Intrinsics.checkParameterIsNotNull((Object)$this$navigationBarHeight, (String)"$this$navigationBarHeight");
        int resourceId = $this$navigationBarHeight.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        int height = $this$navigationBarHeight.getResources().getDimensionPixelSize(resourceId);
        return height;
    }

    @NotNull
    public static final Bitmap drawTextToBitmap(@NotNull Bitmap bitmap, @NotNull Context context, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        float scale = resources.getDisplayMetrics().density;
        Bitmap.Config bitmapConfig = bitmap.getConfig();
        if (bitmapConfig == null) {
            bitmapConfig = Bitmap.Config.ARGB_8888;
        }
        Bitmap newBitmap = bitmap.copy(bitmapConfig, true);
        Canvas canvas = new Canvas(newBitmap);
        Paint paint = new Paint(1);
        boolean bl = false;
        boolean bl2 = false;
        Paint it = paint;
        boolean bl3 = false;
        it.setColor(-16777216);
        it.setTextSize((float)12 * scale);
        it.setShadowLayer(1.0f, 0.0f, 1.0f, -1);
        Paint paint2 = paint;
        Rect bounds = new Rect();
        paint2.getTextBounds(text, 0, text.length(), bounds);
        int x = (bitmap.getWidth() - bounds.width()) / 2;
        int y = (bitmap.getHeight() + bounds.height()) / 2;
        canvas.drawText(text, (float)x, (float)y, paint2);
        Bitmap bitmap2 = newBitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"newBitmap");
        return bitmap2;
    }
}

