/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.base.view.floatview;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.RequiresApi;
import com.talpa.base.view.floatview.PermissionListener;
import com.talpa.base.view.floatview.PermissionUtil;
import java.util.ArrayList;
import java.util.List;

public class FloatActivity
extends Activity {
    private static List<PermissionListener> mPermissionListenerList;
    private static PermissionListener mPermissionListener;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 23) {
            this.requestAlertWindowPermission();
        }
    }

    @RequiresApi(api=23)
    private void requestAlertWindowPermission() {
        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        intent.setData(Uri.parse((String)("package:" + this.getPackageName())));
        this.startActivityForResult(intent, 756232212);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 756232212) {
            if (PermissionUtil.hasPermissionOnActivityResult((Context)this)) {
                if (mPermissionListener != null) {
                    mPermissionListener.onSuccess();
                }
            } else if (mPermissionListener != null) {
                mPermissionListener.onFail();
            }
        }
        this.finish();
    }

    public static synchronized void request(Context context, PermissionListener permissionListener) {
        if (PermissionUtil.hasPermission(context)) {
            permissionListener.onSuccess();
            return;
        }
        if (mPermissionListenerList == null) {
            mPermissionListenerList = new ArrayList<PermissionListener>();
            mPermissionListener = new PermissionListener(){

                @Override
                public void onSuccess() {
                    for (PermissionListener listener : mPermissionListenerList) {
                        listener.onSuccess();
                    }
                    mPermissionListenerList.clear();
                }

                @Override
                public void onFail() {
                    for (PermissionListener listener : mPermissionListenerList) {
                        listener.onFail();
                    }
                    mPermissionListenerList.clear();
                }
            };
            Intent intent = new Intent(context, FloatActivity.class);
            intent.setFlags(0x10000000);
            context.startActivity(intent);
        }
        mPermissionListenerList.add(permissionListener);
    }
}

