/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.base.view.floatview;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.talpa.base.BaseApp;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0004J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\b\u0010\u0012\u001a\u00020\fH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/talpa/base/view/floatview/TapOverlayView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "dp2px", "", "dp", "onConfigurationChanged", "", "newConfig", "Landroid/content/res/Configuration;", "overlayViewDefaultHeight", "overlayViewDefaultPoint", "Landroid/graphics/Point;", "overlayViewDefaultWidth", "updateViewLayout", "x", "y", "translation_sdkRelease"})
public final class TapOverlayView
extends ConstraintLayout {
    private HashMap _$_findViewCache;

    protected void onConfigurationChanged(@Nullable Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Point point = this.overlayViewDefaultPoint();
        this.updateViewLayout(point.x, point.y);
    }

    private final Point overlayViewDefaultPoint() {
        Point outSize = new Point();
        Object object = BaseApp.INSTANCE.getAppContext().getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager windowManager = (WindowManager)object;
        Display display = windowManager.getDefaultDisplay();
        display.getSize(outSize);
        float x = (float)outSize.x - this.overlayViewDefaultWidth();
        float y = ((float)outSize.y - this.overlayViewDefaultHeight()) / (float)5 * (float)2;
        outSize.set((int)x, (int)y);
        return outSize;
    }

    private final float overlayViewDefaultWidth() {
        return this.dp2px(100.0f);
    }

    private final float overlayViewDefaultHeight() {
        return this.dp2px(100.0f);
    }

    protected final float dp2px(float dp) {
        Resources resources = Resources.getSystem();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"Resources.getSystem()");
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
    }

    private final void updateViewLayout(int x, int y) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager.LayoutParams");
        }
        WindowManager.LayoutParams params = (WindowManager.LayoutParams)layoutParams;
        params.x = x;
        params.y = y;
        try {
            Object object = this.getContext().getSystemService("window");
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
            }
            WindowManager windowManager = (WindowManager)object;
            windowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)params);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public TapOverlayView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
    }

    public TapOverlayView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
    }

    public TapOverlayView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

