/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.engine.action;

import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.talpa.camera.cameraview.engine.action.ActionHolder;
import com.talpa.camera.cameraview.engine.action.ActionWrapper;
import com.talpa.camera.cameraview.engine.action.BaseAction;

@RequiresApi(value=21)
class TimeoutAction
extends ActionWrapper {
    private long startMillis;
    private long timeoutMillis;
    private BaseAction action;

    TimeoutAction(long timeoutMillis, @NonNull BaseAction action) {
        this.timeoutMillis = timeoutMillis;
        this.action = action;
    }

    @Override
    @NonNull
    public BaseAction getAction() {
        return this.action;
    }

    @Override
    protected void onStart(@NonNull ActionHolder holder) {
        this.startMillis = System.currentTimeMillis();
        super.onStart(holder);
    }

    @Override
    public void onCaptureCompleted(@NonNull ActionHolder holder, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        super.onCaptureCompleted(holder, request, result);
        if (!this.isCompleted() && System.currentTimeMillis() > this.startMillis + this.timeoutMillis) {
            this.getAction().abort(holder);
        }
    }
}

