/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.engine.mappers;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.talpa.camera.cameraview.controls.Control;
import com.talpa.camera.cameraview.controls.Facing;
import com.talpa.camera.cameraview.controls.Flash;
import com.talpa.camera.cameraview.controls.Hdr;
import com.talpa.camera.cameraview.controls.WhiteBalance;
import java.util.HashMap;
import java.util.Map;

public class Camera1Mapper {
    private static Camera1Mapper sInstance;
    private static final Map<Flash, String> FLASH;
    private static final Map<WhiteBalance, String> WB;
    private static final Map<Facing, Integer> FACING;
    private static final Map<Hdr, String> HDR;

    @NonNull
    public static Camera1Mapper get() {
        if (sInstance == null) {
            sInstance = new Camera1Mapper();
        }
        return sInstance;
    }

    private Camera1Mapper() {
    }

    @NonNull
    public String mapFlash(@NonNull Flash flash) {
        return FLASH.get(flash);
    }

    public int mapFacing(@NonNull Facing facing) {
        return FACING.get(facing);
    }

    @NonNull
    public String mapWhiteBalance(@NonNull WhiteBalance whiteBalance) {
        return WB.get(whiteBalance);
    }

    @NonNull
    public String mapHdr(@NonNull Hdr hdr) {
        return HDR.get(hdr);
    }

    @Nullable
    public Flash unmapFlash(@NonNull String cameraConstant) {
        return this.reverseLookup(FLASH, cameraConstant);
    }

    @Nullable
    public Facing unmapFacing(int cameraConstant) {
        return this.reverseLookup(FACING, cameraConstant);
    }

    @Nullable
    public WhiteBalance unmapWhiteBalance(@NonNull String cameraConstant) {
        return this.reverseLookup(WB, cameraConstant);
    }

    @Nullable
    public Hdr unmapHdr(@NonNull String cameraConstant) {
        return this.reverseLookup(HDR, cameraConstant);
    }

    @Nullable
    private <C extends Control, T> C reverseLookup(@NonNull Map<C, T> map, @NonNull T object) {
        for (Control value : map.keySet()) {
            if (!object.equals(map.get(value))) continue;
            return (C)value;
        }
        return null;
    }

    static {
        FLASH = new HashMap<Flash, String>();
        WB = new HashMap<WhiteBalance, String>();
        FACING = new HashMap<Facing, Integer>();
        HDR = new HashMap<Hdr, String>();
        FLASH.put(Flash.OFF, "off");
        FLASH.put(Flash.ON, "on");
        FLASH.put(Flash.AUTO, "auto");
        FLASH.put(Flash.TORCH, "torch");
        FACING.put(Facing.BACK, 0);
        FACING.put(Facing.FRONT, 1);
        WB.put(WhiteBalance.AUTO, "auto");
        WB.put(WhiteBalance.INCANDESCENT, "incandescent");
        WB.put(WhiteBalance.FLUORESCENT, "fluorescent");
        WB.put(WhiteBalance.DAYLIGHT, "daylight");
        WB.put(WhiteBalance.CLOUDY, "cloudy-daylight");
        HDR.put(Hdr.OFF, "auto");
        if (Build.VERSION.SDK_INT >= 17) {
            HDR.put(Hdr.ON, "hdr");
        } else {
            HDR.put(Hdr.ON, "hdr");
        }
    }
}

