/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.engine.meter;

import android.hardware.camera2.params.MeteringRectangle;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.talpa.camera.cameraview.CameraLogger;
import com.talpa.camera.cameraview.engine.action.ActionHolder;
import com.talpa.camera.cameraview.engine.action.BaseAction;
import java.util.List;

@RequiresApi(value=21)
public abstract class BaseMeter
extends BaseAction {
    private static final String TAG = BaseMeter.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private final List<MeteringRectangle> areas;
    private boolean isSuccessful;
    private boolean skipIfPossible;

    protected BaseMeter(@NonNull List<MeteringRectangle> areas, boolean skipIfPossible) {
        this.areas = areas;
        this.skipIfPossible = skipIfPossible;
    }

    @Override
    protected final void onStart(@NonNull ActionHolder holder) {
        super.onStart(holder);
        boolean isSkipped = this.skipIfPossible && this.checkShouldSkip(holder);
        boolean isSupported = this.checkIsSupported(holder);
        if (isSupported && !isSkipped) {
            LOG.i("onStart:", "supported and not skipped. Dispatching onStarted.");
            this.onStarted(holder, this.areas);
        } else {
            LOG.i("onStart:", "not supported or skipped. Dispatching COMPLETED state.");
            this.setSuccessful(true);
            this.setState(Integer.MAX_VALUE);
        }
    }

    protected abstract void onStarted(@NonNull ActionHolder var1, @NonNull List<MeteringRectangle> var2);

    protected abstract boolean checkShouldSkip(@NonNull ActionHolder var1);

    protected abstract boolean checkIsSupported(@NonNull ActionHolder var1);

    protected void setSuccessful(boolean successful) {
        this.isSuccessful = successful;
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }
}

