/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.engine.meter;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.talpa.camera.cameraview.CameraLogger;
import com.talpa.camera.cameraview.engine.action.ActionHolder;
import com.talpa.camera.cameraview.engine.meter.BaseReset;

@RequiresApi(value=21)
public class FocusReset
extends BaseReset {
    private static final String TAG = FocusReset.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);

    public FocusReset() {
        super(true);
    }

    @Override
    protected void onStarted(@NonNull ActionHolder holder, @Nullable MeteringRectangle area) {
        TotalCaptureResult lastResult;
        boolean changed = false;
        int maxRegions = this.readCharacteristic(CameraCharacteristics.CONTROL_MAX_REGIONS_AF, 0);
        if (area != null && maxRegions > 0) {
            holder.getBuilder(this).set(CaptureRequest.CONTROL_AF_REGIONS, (Object)new MeteringRectangle[]{area});
            changed = true;
        }
        Integer trigger = (lastResult = holder.getLastResult(this)) == null ? null : (Integer)lastResult.get(CaptureResult.CONTROL_AF_TRIGGER);
        LOG.w("onStarted:", "last focus trigger is", trigger);
        if (trigger != null && trigger == 1) {
            holder.getBuilder(this).set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            changed = true;
        }
        if (changed) {
            holder.applyBuilder(this);
        }
        this.setState(Integer.MAX_VALUE);
    }
}

