/*
 * Decompiled with CFR 0.152.
 */
package com.talpa.camera.cameraview.engine.orchestrator;

import androidx.annotation.NonNull;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.talpa.camera.cameraview.engine.orchestrator.CameraOrchestrator;
import com.talpa.camera.cameraview.engine.orchestrator.CameraState;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public class CameraStateOrchestrator
extends CameraOrchestrator {
    private CameraState mCurrentState = CameraState.OFF;
    private CameraState mTargetState = CameraState.OFF;
    private int mStateChangeCount = 0;

    public CameraStateOrchestrator(@NonNull CameraOrchestrator.Callback callback) {
        super(callback);
    }

    @NonNull
    public CameraState getCurrentState() {
        return this.mCurrentState;
    }

    @NonNull
    public CameraState getTargetState() {
        return this.mTargetState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPendingStateChange() {
        Object object = this.mLock;
        synchronized (object) {
            for (CameraOrchestrator.Token token : this.mJobs) {
                if (!token.name.contains(" >> ") && !token.name.contains(" << ") || token.task.isComplete()) continue;
                return true;
            }
            return false;
        }
    }

    @NonNull
    public <T> Task<T> scheduleStateChange(final @NonNull CameraState fromState, final @NonNull CameraState toState, boolean dispatchExceptions, final @NonNull Callable<Task<T>> stateChange) {
        final int changeCount = ++this.mStateChangeCount;
        this.mTargetState = toState;
        final boolean isTearDown = !toState.isAtLeast(fromState);
        final String name = isTearDown ? fromState.name() + " << " + toState.name() : fromState.name() + " >> " + toState.name();
        return this.schedule(name, dispatchExceptions, new Callable<Task<T>>(){

            @Override
            public Task<T> call() throws Exception {
                if (CameraStateOrchestrator.this.getCurrentState() != fromState) {
                    CameraOrchestrator.LOG.w(new Object[]{name.toUpperCase(), "- State mismatch, aborting. current:", CameraStateOrchestrator.this.getCurrentState(), "from:", fromState, "to:", toState});
                    return Tasks.forCanceled();
                }
                Executor executor = CameraStateOrchestrator.this.mCallback.getJobWorker(name).getExecutor();
                return ((Task)stateChange.call()).continueWithTask(executor, new Continuation<T, Task<T>>(){

                    public Task<T> then(@NonNull Task<T> task) {
                        if (task.isSuccessful() || isTearDown) {
                            CameraStateOrchestrator.this.mCurrentState = toState;
                        }
                        return task;
                    }
                });
            }
        }).addOnCompleteListener(new OnCompleteListener<T>(){

            public void onComplete(@NonNull Task<T> task) {
                if (changeCount == CameraStateOrchestrator.this.mStateChangeCount) {
                    CameraStateOrchestrator.this.mTargetState = CameraStateOrchestrator.this.mCurrentState;
                }
            }
        });
    }

    @NonNull
    public Task<Void> scheduleStateful(@NonNull String name, final @NonNull CameraState atLeast, final @NonNull Runnable job) {
        return this.schedule(name, true, new Runnable(){

            @Override
            public void run() {
                if (CameraStateOrchestrator.this.getCurrentState().isAtLeast(atLeast)) {
                    job.run();
                }
            }
        });
    }

    public void scheduleStatefulDelayed(@NonNull String name, final @NonNull CameraState atLeast, long delay, final @NonNull Runnable job) {
        this.scheduleDelayed(name, delay, new Runnable(){

            @Override
            public void run() {
                if (CameraStateOrchestrator.this.getCurrentState().isAtLeast(atLeast)) {
                    job.run();
                }
            }
        });
    }
}

